/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.publish;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.dao.DeployParamRecordMongoDao;
import com.digiwin.athena.domain.DeployParamRecord;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.domain.PageDesignTime;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.dto.DeployDataDto;
import com.digiwin.athena.dto.PageDesignBusinessDto;
import com.digiwin.athena.http.distribution.DeleteFxJobReqDto;
import com.digiwin.athena.http.distribution.FxApiHelper;
import com.digiwin.athena.http.distribution.FxRegisterJobDetailDto;
import com.digiwin.athena.http.distribution.GetFxJobListReqDto;
import com.digiwin.athena.http.distribution.RegisterFxJobReqDto;
import com.digiwin.athena.http.distribution.SyncFileInfoReqDto;
import com.digiwin.athena.publish.PublishExtendOperationWrapper;
import com.digiwin.athena.utils.user.UserHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="pageDesignExtendWrapper")
@ConditionalOnProperty(name={"system_env"}, havingValue="FenXiao")
public class FxPageDesignExtendWrapper
extends PublishExtendOperationWrapper<PageDesignBusinessDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FxPageDesignExtendWrapper.class);
    @Autowired
    private FxApiHelper fxApiHelper;
    @Autowired
    private DeployParamRecordMongoDao deployParamRecordMongoDao;

    public List<PageDesignBusinessDto> doCompile(List<PageDesignBusinessDto> data) {
        JSONArray sysEnumList = this.fxApiHelper.getSysEnum();
        for (Object o : sysEnumList) {
            JSONObject jo = (JSONObject)o;
            JSONObject variable = new JSONObject();
            variable.put("name", (Object)jo.getString("id"));
            variable.put("defaultValue", (Object)jo.getString("value"));
            variable.put("scope", (Object)"system");
            for (PageDesignBusinessDto businessDto : data) {
                businessDto.getPageDslList().forEach(b -> b.getDsl().getVariables().add(variable));
            }
        }
        return data;
    }

    public void endPostHandle(DeployDataDto<PageDesignBusinessDto> deployDataDto) {
        List publishDataList = deployDataDto.getPublishData();
        Set codes = publishDataList.stream().map(p -> p.getPageDesign().getCode()).collect(Collectors.toSet());
        DeployParamRecord deployParamRecord = this.deployParamRecordMongoDao.selectByApplicationAndType(deployDataDto.getAdpApplication(), "pageDesignDeployData");
        if (deployParamRecord != null) {
            List values = (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)deployParamRecord.getValue()), (TypeReference)new TypeReference<List<JSONObject>>(){}, (Feature[])new Feature[0]);
            ArrayList<DeleteFxJobReqDto> deleteFxJobReqDtos = new ArrayList<DeleteFxJobReqDto>();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                JSONObject next = (JSONObject)iterator.next();
                String code = next.getString("code");
                if (codes.contains(code)) continue;
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("aah001", code);
                FxRegisterJobDetailDto jobDetailInfo = this.fxApiHelper.getJobDetailInfo(param);
                if (jobDetailInfo != null) {
                    DeleteFxJobReqDto deleteFxJobReqDto = new DeleteFxJobReqDto();
                    deleteFxJobReqDto.setAah001(code);
                    deleteFxJobReqDto.setAahlock(jobDetailInfo.getAahlock());
                    deleteFxJobReqDtos.add(deleteFxJobReqDto);
                }
                iterator.remove();
            }
            if (!deleteFxJobReqDtos.isEmpty()) {
                this.fxApiHelper.deleteJob(deleteFxJobReqDtos);
                deployParamRecord.setValue((Object)values);
                this.deployParamRecordMongoDao.save(deployParamRecord);
            }
        }
    }

    public PageDesignBusinessDto postHandle(PageDesignBusinessDto publishData) {
        ArrayList<JSONObject> valueList;
        PageDesign pageDesign = publishData.getPageDesign();
        DeployParamRecord deployParamRecord = this.deployParamRecordMongoDao.selectByApplicationAndType(pageDesign.getAdpApplication(), "pageDesignDeployData");
        if (deployParamRecord == null) {
            deployParamRecord = new DeployParamRecord();
            deployParamRecord.setAdpApplication(pageDesign.getAdpApplication());
            deployParamRecord.setType("pageDesignDeployData");
            UserHelper.fillCreateInfo((Object)deployParamRecord);
            UserHelper.fillEditInfo((Object)deployParamRecord);
            valueList = new ArrayList<JSONObject>();
        } else {
            UserHelper.fillEditInfo((Object)deployParamRecord);
            valueList = (ArrayList<JSONObject>)JSONObject.parseObject((String)JSONObject.toJSONString((Object)deployParamRecord.getValue()), (TypeReference)new TypeReference<List<JSONObject>>(){}, (Feature[])new Feature[0]);
            valueList.removeIf(v -> v.getString("code").equals(pageDesign.getCode()));
        }
        JSONObject newParam = new JSONObject();
        newParam.put("code", (Object)pageDesign.getCode());
        newParam.put("name", (Object)pageDesign.getName());
        valueList.add(newParam);
        deployParamRecord.setValue(valueList);
        this.registerFxJob(publishData);
        if (deployParamRecord.getObjectId() == null) {
            this.deployParamRecordMongoDao.insert(deployParamRecord);
        } else {
            this.deployParamRecordMongoDao.save(deployParamRecord);
        }
        return publishData;
    }

    public PageDesignBusinessDto preHandle(PageDesignBusinessDto publishData) {
        List<PageDsl> pageDslList = publishData.getPageDslList();
        pageDslList.stream().map(PageDsl::getDesignTime).filter(Objects::nonNull).map(PageDesignTime::getDataImportInfo).filter(Objects::nonNull).filter(d -> !CollectionUtils.isEmpty(d.getComponentList())).map(d -> (SyncFileInfoReqDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)d), SyncFileInfoReqDto.class)).forEach(arg_0 -> ((FxApiHelper)this.fxApiHelper).syncFileInfo(arg_0));
        return publishData;
    }

    private void registerFxJob(PageDesignBusinessDto businessDto) {
        PageDesign pageDesign = businessDto.getPageDesign();
        GetFxJobListReqDto getFxJobListReqDto = new GetFxJobListReqDto();
        getFxJobListReqDto.setGlikesel(pageDesign.getCode());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("aah001", pageDesign.getCode());
        FxRegisterJobDetailDto jobDetailInfo = this.fxApiHelper.getJobDetailInfo(param);
        if (jobDetailInfo == null) {
            RegisterFxJobReqDto fxJobMenuParam = RegisterFxJobReqDto.createFxJobMenuParam((String)pageDesign.getCode(), (String)pageDesign.getName());
            this.buildComponentLists(pageDesign, businessDto.getPageDslList(), fxJobMenuParam);
            this.fxApiHelper.registerJob(fxJobMenuParam);
        } else {
            String newName = pageDesign.getName();
            jobDetailInfo.setAah001_n1_o(jobDetailInfo.getAah001_n1());
            jobDetailInfo.setAah001_n1(newName);
            this.buildComponentLists(pageDesign, businessDto.getPageDslList(), jobDetailInfo);
            this.fxApiHelper.updateJobInfo(jobDetailInfo);
        }
    }

    private void buildComponentLists(PageDesign pageDesign, List<PageDsl> dslList, Object reqDto) {
        List list = CollUtil.emptyIfNull(dslList).stream().flatMap(v -> Optional.ofNullable(v).map(PageDsl::getDesignTime).map(PageDesignTime::getAuthority).orElse(Collections.emptyList()).stream()).toList();
        if (list.isEmpty()) {
            return;
        }
        ArrayList<JSONObject> aajList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> adeList = new ArrayList<JSONObject>();
        for (PageDesignTime.Authority authority : list) {
            if (authority.getComponentInfo() == null || authority.getKey() == null) continue;
            String category = authority.getComponentInfo().getCategory();
            if ("functional".equals(category)) {
                aajList.add(RegisterFxJobReqDto.buildAaj((String)pageDesign.getCode(), (String)authority.getKey(), authority.getNameLangDto()));
                continue;
            }
            if (!"component".equals(category)) continue;
            adeList.add(RegisterFxJobReqDto.buildAde((String)authority.getKey(), authority.getNameLangDto()));
        }
        if (reqDto instanceof RegisterFxJobReqDto) {
            RegisterFxJobReqDto dto = (RegisterFxJobReqDto)reqDto;
            dto.setAajList(aajList);
            dto.setAdeList(adeList);
        } else if (reqDto instanceof FxRegisterJobDetailDto) {
            FxRegisterJobDetailDto dto = (FxRegisterJobDetailDto)reqDto;
            dto.setAajList(aajList);
            dto.setAdeList(adeList);
        }
    }
}

