/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.domain.PageDesignTime;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.mongodb.domain.appCustomConfig.CustomControlRelation;
import com.digiwin.athena.service.appCustomConfig.CustomControlEventListener;
import com.digiwin.athena.service.appCustomConfig.event.CustomControlEventManager;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NewPageDesignEventListener
extends CustomControlEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewPageDesignEventListener.class);

    public void doEvent(Object obj) {
        JSONObject pageDesignJo = (JSONObject)obj;
        PageDesign pageDesign = (PageDesign)pageDesignJo.toJavaObject(PageDesign.class);
        List pageDslList = (List)pageDesignJo.get((Object)"pageDslList");
        String tenantId = CurThreadInfoUtils.getCurTokenTenant().getTenantId();
        Map typeMapCode = this.getTypeMapCodeRes(pageDesignJo.getString("adpApplication"), tenantId);
        for (PageDsl pageDsl : pageDslList) {
            PageDesignTime designTime = pageDsl.getDesignTime();
            if (designTime == null) continue;
            ArrayList<CustomControlRelation> customControlRelations = new ArrayList<CustomControlRelation>();
            Collection customControlList = designTime.getCustomControlList().stream().map(c -> c.getType()).collect(Collectors.toList());
            for (String control : customControlList) {
                if (!typeMapCode.containsKey(control)) continue;
                CustomControlRelation customControlRelation = new CustomControlRelation();
                customControlRelation.setName(pageDesign.getName());
                customControlRelation.setLang(pageDesign.getLang());
                customControlRelation.setAdpTenantId(tenantId);
                customControlRelation.setAdpApplication(pageDesign.getAdpApplication());
                customControlRelation.setTargetCode(pageDesign.getCode());
                customControlRelation.setUiKey(pageDsl.getCode());
                customControlRelation.setTargetType(this.getType().getCode());
                customControlRelation.setCustomControlType(control);
                customControlRelation.setSourceCode((String)typeMapCode.get(control));
                UserHelper.fillCreateInfo((Object)customControlRelation);
                UserHelper.fillEditInfo((Object)customControlRelation);
                customControlRelations.add(customControlRelation);
            }
            if (customControlRelations.isEmpty()) continue;
            this.customControlRelationV2MongoDao.deleteByUiKeyAndTargetCode(pageDsl.getCode(), pageDesign.getCode());
            this.customControlRelationV2MongoDao.insertAll(customControlRelations);
        }
    }

    protected CustomControlEventManager.EvenType getType() {
        return CustomControlEventManager.EvenType.NEW_PAGE_DESIGN;
    }
}

