package com.digiwin.athena.dto;

import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import lombok.Data;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class QueryPageDesignResDto {

    private String code;

    private String name;

    private String templateType;

    private String category;

    private Map<String, MultiLanguageDTO> lang;

    private String dslCode;

    private List<PageDsl> pageDslList;

    private Date publishedTime;

    private Boolean isMobile;
    public static QueryPageDesignResDto create(PageDesign pageDesign) {
        QueryPageDesignResDto queryPageDesignResDto = new QueryPageDesignResDto();
        queryPageDesignResDto.setCode(pageDesign.getCode());
        queryPageDesignResDto.setName(pageDesign.getName());
        queryPageDesignResDto.setTemplateType(pageDesign.getTemplateType());
        queryPageDesignResDto.setLang(pageDesign.getLang());
        queryPageDesignResDto.setDslCode(pageDesign.getDslCode());
        queryPageDesignResDto.setPublishedTime(pageDesign.getPublishedTime());
        queryPageDesignResDto.setIsMobile(pageDesign.getIsMobile());
        queryPageDesignResDto.setCategory(PageDesign.EDITABLE_TABLE_TEMPLATE_TYPE.equals(pageDesign.getTemplateType())?"SIGN-DOCUMENT":"DOUBLE-DOCUMENT-FORM");

        return queryPageDesignResDto;
    }
}
