/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.validate;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.ConstraintViolation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.hibernate.validator.internal.engine.path.NodeImpl;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationUtil.class);

    public static String transformFieldPath(ConstraintViolation<?> violation) {
        if (!(violation.getPropertyPath() instanceof PathImpl)) {
            log.warn("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\u4fe1\u606f\u56de\u663e\uff1a\u53c2\u6570\u6821\u9a8c\u5b9e\u73b0\u4e0d\u4e3aHibernate Validator!type:{}", (Object)violation.getClass());
            return violation.getPropertyPath().toString();
        }
        PathImpl path = (PathImpl)violation.getPropertyPath();
        NodeImpl leafNode = path.getLeafNode();
        LinkedList<String> fieldNameList = new LinkedList<String>();
        do {
            String fieldName = leafNode.getName();
            String fieldDesc = ValidationUtil.getFieldDesc(violation, leafNode, fieldName);
            fieldNameList.addFirst(fieldDesc);
        } while ((leafNode = leafNode.getParent()) != null && leafNode.getParent().getValue() != null);
        return StrUtil.join((CharSequence)"/", fieldNameList);
    }

    private static String getFieldDesc(ConstraintViolation<?> violation, NodeImpl leafNode, String fieldName) {
        try {
            Field field = ValidationUtil.getField(leafNode, fieldName);
            if (field == null) {
                log.warn("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\u4fe1\u606f\u56de\u663e\uff1a\u5b57\u6bb5\u4e0d\u5b58\u5728! propertyPath:{},fieldName:{},parent:{}", new Object[]{violation.getPropertyPath(), fieldName, leafNode.getParent().getValue()});
                return fieldName;
            }
            Schema schema = (Schema)AnnotationUtil.getAnnotation((AnnotatedElement)field, Schema.class);
            if (schema == null) {
                return fieldName;
            }
            fieldName = StrUtil.blankToDefault((CharSequence)schema.name(), (String)schema.description());
        }
        catch (Exception ex) {
            log.error("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\u4fe1\u606f\u56de\u663e\uff1a\u5b57\u6bb5\u540d\u79f0\u8f6c\u6362\u5f02\u5e38\uff01", (Throwable)ex);
        }
        return fieldName;
    }

    private static Field getField(NodeImpl leafNode, String fieldName) {
        Object parentVal = leafNode.getParent().getValue();
        if (parentVal == null) {
            return null;
        }
        if (leafNode.getKey() != null && parentVal instanceof Map) {
            parentVal = ((Map)parentVal).get(leafNode.getKey());
        }
        return ReflectUtil.getField(parentVal.getClass(), (String)fieldName);
    }
}

