package com.digiwin.athena.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.base.ResultBean;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.dto.PageDesignDto;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.service.RuntimeDataQuery;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 页面设计器V1
 */
@Validated
@RestController
@Slf4j
@RequestMapping("/pageDesign/v2")
@Tag(name = "查询运行时作业",description = "07875464-f0f1-4a1c-9892-32c3a323e0cc")
public class RPageDesignController {

    @Autowired
    @Qualifier("pageDesignRuntime")
    private RuntimeDataQuery<PageDesignDto> runtimeDataQuery;


    @Autowired
    @Qualifier("appPageDesignRuntime")
    private RuntimeDataQuery<List<PageDesign>> appPageDesignRuntime;
    /**
     * 通过作业Code查询对应作业信息
     * @param code 作业code
     * @return ResultBean
     */
    @GetMapping("/queryDslByCode")
    @Operation(summary = "查询作业dsl")
    public ResultBean<PageDesignDto> queryDslByCode(@RequestParam(value = "code", required = false) String code,
                                                    @RequestParam(value = "dslCode",required = false) String dslCode) {


        JSONObject params = new JSONObject();
        params.put("code",code);
        params.put("dslCode",dslCode);
        return ResultBean.success(runtimeDataQuery.queryRuntimeData(params));
    }

    @GetMapping("/queryPageList")
    @Operation(summary = "查询应用下的web端作业")
    public ResultDto<List<PageDesign>> queryPageList(String application){
        JSONObject params = new JSONObject();
        params.put("application",application);
        List<PageDesign> pageDesignList = appPageDesignRuntime.queryRuntimeData(params);
        List<PageDesign> res = pageDesignList.stream().filter(p -> !Boolean.TRUE.equals(p.getIsMobile())).collect(Collectors.toList());
        return ResultDto.createSuccess(res);
    }

}