package com.digiwin.athena.dao;

import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

@Slf4j
@Repository
public class RPageDslDao {

    @Autowired
    private MongoRuntimeRepositoryDecorator mongoRuntimeRepositoryDecorator;

    /**
     * 插入PageDsl
     */
    public void insert(PageDsl pageDsl) {
        mongoRuntimeRepositoryDecorator.insert(pageDsl);
    }

    public void batchInsert(List<PageDsl> pageDslList) {
        mongoRuntimeRepositoryDecorator.insertAll(PageDsl.class, pageDslList);
    }

    /**
     * 根据code删除
     */
    public void deleteByCode(String code) {
        Criteria criteria = Criteria.where("code").is(code);
        mongoRuntimeRepositoryDecorator.remove(new Query(criteria), PageDsl.class);
    }

    public long deleteByPageDesignCode(String pageDesignCode) {
        Criteria criteria = Criteria.where("pageDesignCode").is(pageDesignCode);
        return mongoRuntimeRepositoryDecorator.remove(new Query(criteria), PageDsl.class);
    }

    /**
     * 更新PageDsl
     */
    public void update(PageDsl pageDsl) {
        mongoRuntimeRepositoryDecorator.save(pageDsl);
    }

    /**
     * 根据code查询
     */
    public PageDsl findByCode(String code,String pageDesignCode) {
        Criteria criteria = Criteria.where("code").is(code);
        if (StringUtils.isNotEmpty(pageDesignCode)){
            criteria = criteria.and("pageDesignCode").is(pageDesignCode);
        }
        return mongoRuntimeRepositoryDecorator.findOne(new Query(criteria), PageDsl.class);
    }

    /**
     * 根据条件查询
     */
    public List<PageDsl> find(Query query) {
        return mongoRuntimeRepositoryDecorator.find(query, PageDsl.class);
    }

    /**
     * 根据条件查询单个
     */
    public PageDsl findOne(Query query) {
        return mongoRuntimeRepositoryDecorator.findOne(query, PageDsl.class);
    }

    /**
     * 删除实体
     */
    public void delete(PageDsl pageDsl) {
        mongoRuntimeRepositoryDecorator.delete(pageDsl);
    }

    public void insertAll(List<PageDsl> pageDslList) {
        mongoRuntimeRepositoryDecorator.insertAll(pageDslList);
    }

    public void deleteByCodeAndApplication(List<String> pageDslCodes, String application) {
        Criteria criteria = Criteria.where("code").in(pageDslCodes).and("adpApplication").is(application);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria), PageDsl.class);
    }

    public void deleteByPageDesignCodes(Collection<String> rCodes, String adpApplication) {
        Criteria criteria = Criteria.where("pageDesignCode").in(rCodes).and("adpApplication").is(adpApplication);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria), PageDsl.class);
    }

    public void deleteByApplication(String appCode) {
        Criteria criteria = Criteria.where("adpApplication").is(appCode);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria), PageDsl.class);
    }
}