package com.digiwin.athena.domain;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.validate.ValidLangLen;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Length;

import java.beans.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Data
@Accessors(chain = true)
public class PageDesignTime {
    /**
     * 按钮类组件
     */
    public static final String AUTH_COMP_CALS_FUNC = "functional";
    /**
     * 展示类组件
     */
    public static final String AUTH_COMP_CALS_COMP = "component";


    @Schema(name = "权限控制")
    @Valid
    private List<Authority> authority = new ArrayList<>();

    @Schema(description = "控件集合")
    private Collection<CustomControlInfo> customControlList = new ArrayList<>();

    private DataImportInfo dataImportInfo;

    private Object importTemplate;
    private Object schema;
    private Object componentTitleMeta;
    private Object nodeTitleMap;
    private Object availableComponentList;
    private Object frontend;

    @Data
    public static class DataImportInfo{
        private String programName;
        private String programId;

        private List<Component> componentList;
    }

    @Data
    public static class Component{
        private String componentId;
        private String componentName;

        private List<FileInfo> fileList;
    }

    @Data
    public static class FileInfo{
        private String fileUrl;
        private String importApi;
        private String fileName;
        private String fileId;
    }

    @Data
    public static class CustomControlInfo{
        private String type;

        private String customConfigCode;
    }

    @Data
    public static class Authority {
        /**
         * 权限项代号/编码
         */
        @Schema(name = "权限项代号")
        @NotBlank
        @Length(max = 40, message = "{org.hibernate.validator.constraints.LengthMax.message}")
        private String key;

        /**
         * 权限项名称
         */
        @Schema(name = "权限项名称")
        @NotBlank
        @Length(max = 80, message = "{org.hibernate.validator.constraints.LengthMax.message}")
        private String name;

        @Schema(name = "权限项名称-多语言")
        @NotEmpty
        @ValidLangLen(max = 80, message = "{org.hibernate.validator.constraints.LengthMax.message}")
        private Map<String, MultiLanguageDTO<?>> lang;

        private ComponentInfo componentInfo;

        @Transient
        public MultiLanguageDTO<?> getNameLangDto() {
            return lang != null ? lang.get("name") : null;
        }
    }

    @Data
    public static class ComponentInfo {
        /**
         * 前端组件id
         */
        private String id;

        /**
         * 组件类别，功能权限functional、 组件权限component
         */
        @Schema(description = "组件类别，功能权限functional、 组件权限component")
        private String category;
    }
}
