package com.digiwin.athena.domain;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.MongoBaseDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Map;

/**
 * 新版页面设计器使用
 * @author Jiangmx
 * @date 2025/6/23
 */
@Data
@Accessors(chain = true)
@Document(collection = "pageDsl")
public class PageDsl extends MongoBaseDto {

    public static final String BROWSE_TYPE="browse";
    public static final String EDIT_TYPE="edit";
    public static final String DESIGN_TYPE="design";

    @Id
    private String objectId;


    @Schema(description = "页面code")
    private String code;
    private String name;

    /**
     * 版本号
     */
    private String version;

    /**
     * 作业code，PageDesign.code
     */
    @Schema(description = "作业code")
    private String pageDesignCode;

    private Dsl dsl = new Dsl();

    /**
     * 设计时自留数据
     */
    private PageDesignTime designTime = new PageDesignTime();

    @Schema(description = "页面类型|browse-浏览，edit-编辑")
    private String type;

    private String adpApplication;

    private String adpTenantId;

    private Map<String, MultiLanguageDTO> lang;

}
