package com.digiwin.athena.dto;

import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Data
public class CreatePageDesignDto {

    @Schema(description = "添加类型|basic_table-基础表格，editable_table-可编辑表格")
    @NotEmpty(message = "templateType不能为空")
    private String templateType;
    @Schema(description = "应用code")
    private String application;
    @Schema(description = "作业名")
    private String name;

    private String version;

    private String dslCode;

    private Boolean isMobile;
    private Map<String, MultiLanguageDTO> lang;

    private List<PageDslDto> pageDslList = new ArrayList<>();

    public PageDesign createPageDesign(){
        PageDesign pageDesign = new PageDesign();
        pageDesign.setLang(this.lang);
        pageDesign.setName(this.name);
        pageDesign.setAdpApplication(this.application);
        pageDesign.setAdpTenantId(CurThreadInfoUtils.getCurTokenTenant().getTenantId());
        pageDesign.setTemplateType(this.templateType);
        pageDesign.setIsMobile(this.isMobile);
        pageDesign.setDslCode(this.dslCode);
        UserHelper.fillCreateInfo(pageDesign);
        UserHelper.fillEditInfo(pageDesign);
        return pageDesign;
    }

    public PageDsl createPageDsl() {
        PageDsl pageDsl = new PageDsl();
        pageDsl.setAdpApplication(this.application);
        pageDsl.setAdpTenantId(CurThreadInfoUtils.getCurTokenTenant().getTenantId());
        pageDsl.setVersion(this.version);

        UserHelper.fillCreateInfo(pageDsl);
        UserHelper.fillEditInfo(pageDsl);
        return pageDsl;
    }
}
