package com.digiwin.athena.dto;

import com.digiwin.athena.domain.Dsl;
import com.digiwin.athena.domain.PageDesignTime;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class PageDslDto {

    private String code;

    private Dsl dsl = new Dsl();

    @Schema(description = "页面类型|browse-浏览，edit-编辑")
    private String type;

    /**
     * 设计时数据保存
     */
    private PageDesignTime designTime;

    private String name;

    private String pageDesignCode;

    private String application;

    private String version;

    private Map<String, MultiLanguageDTO> lang = new HashMap<>();

    public PageDsl createPageDsl() {

        PageDsl pageDsl = new PageDsl();
        pageDsl.setAdpApplication(this.application);
        pageDsl.setAdpTenantId(CurThreadInfoUtils.getCurTokenTenant().getTenantId());
        pageDsl.setVersion(this.version);
        pageDsl.setLang(this.lang);
        pageDsl.setPageDesignCode(this.pageDesignCode);
        pageDsl.setDsl(this.dsl);
        pageDsl.setName(this.name);

        UserHelper.fillCreateInfo(pageDsl);
        UserHelper.fillEditInfo(pageDsl);

        return pageDsl;
    }
}
