package com.digiwin.athena.dto;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import lombok.Data;

import java.util.Map;

@Data
public class SavePageDesignBasicInfoReqDto {

    @Schema(description = "作业code")
    @NotEmpty(message = "code不能为空")
    private String code;
    @Schema(description = "作业名称")
    @NotEmpty(message = "name不能为空")
    private String name;
    @Schema(description = "应用code")
    @NotEmpty(message = "application不能为空")
    private String application;

    private Map<String, MultiLanguageDTO> lang;
}
