package com.digiwin.athena.service;

import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.dto.CreatePageDesignDto;
import com.digiwin.athena.dto.PageDslDto;
import com.digiwin.athena.dto.QueryPageDesignResDto;
import com.digiwin.athena.dto.SavePageDesignBasicInfoReqDto;
import com.digiwin.athena.dto.SavePageDesignReqDto;

import java.util.List;

public interface DPageDesignService {
    String createPageDesign(CreatePageDesignDto createPageDesignDto);

    QueryPageDesignResDto queryPageDesign(String code,String application);

    void savePageDesign(List<SavePageDesignReqDto> savePageDesignReqDtoList);

    void savePageDesignBasicInfo(SavePageDesignBasicInfoReqDto savePageDesignBasicInfoReqDto);

    void deletePageDesign(String code,String application);

    List<PageDesign> queryPageDesign(String application);
    List<PageDsl> queryPageDslBasic(String application);

    List<PageDsl> getPagesBasicInfo(String code, String application);

    QueryPageDesignResDto queryBasicPageDesign(String code, String application);

    List<QueryPageDesignResDto> getAppPageDesigns(String application);

    String copyPageDesign(String code, String application);

    PageDsl createPage(PageDslDto pageDslDto);

    void deletePageDsl(String code, String pageDesignCode, String application);

    void updatePageDslBasic(PageDslDto pageDslDto);

    void updateActionVersion();
}
