package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.service.MultiPlatformDiffInterface;
import com.digiwin.athena.service.RPageDesignService;
import com.digiwin.athena.service.RuntimeDataQuery;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@Service("appPageDesignRuntime")
@Slf4j
public class AppPageDesignRuntimeDataQuery implements RuntimeDataQuery {

    @Autowired
    private RPageDesignService rPageDesignService;
    @Autowired
    private MultiPlatformDiffInterface multiPlatformDiffInterface;
    @Override
    public Object queryRuntimeData(JSONObject param) {
        List<PageDesign> res = rPageDesignService.queryByApplication(param.getString("application"));
        if (!res.isEmpty()){
            Collection<String> allCodes = res.stream().map(PageDesign::getCode).collect(Collectors.toSet());
            String appCode = param.getString("application");
            Collection<String> authCodes = multiPlatformDiffInterface.getAuthPageDesign(allCodes,appCode);
            res = res.stream().filter(p->authCodes.contains(p.getCode())).collect(Collectors.toList());
        }
        return res;
    }
}
