package com.digiwin.athena.service.impl;

import com.digiwin.athena.dao.RApplicationCustomConfigMongoDao;
import com.digiwin.athena.dao.RCustomControlRelationMongoDao;
import com.digiwin.athena.dao.RPageDesignDao;
import com.digiwin.athena.dao.RPageDslDao;
import com.digiwin.athena.http.distribution.DeleteFxJobReqDto;
import com.digiwin.athena.http.distribution.FxApiHelper;
import com.digiwin.athena.http.distribution.FxRegisterJobDetailDto;
import com.digiwin.athena.service.ApplicationDeleteService;
import com.digiwin.athena.service.MultiPlatformDiffInterface;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

@Service
@Slf4j
public class ApplicationDeleteServiceImpl implements ApplicationDeleteService {

    @Autowired
    private RPageDesignDao rPageDesignDao;
    @Autowired
    private RPageDslDao rPageDslDao;
    @Autowired
    private RApplicationCustomConfigMongoDao rApplicationCustomConfigMongoDao;
    @Autowired
    private MultiPlatformDiffInterface multiPlatformDiffInterface;
    @Autowired
    private RCustomControlRelationMongoDao rCustomControlRelationMongoDao;

    @Override
    public void applicationDeleteOperation(String appCode) {

        Set<String> pageCodes = rPageDesignDao.selectCodeByAdpApplication(appCode);

        multiPlatformDiffInterface.deleteAllRegisterInfo(pageCodes);

        rPageDslDao.deleteByApplication(appCode);
        rPageDesignDao.deleteByApplication(appCode);
        rApplicationCustomConfigMongoDao.deleteByApplication(appCode);
        rCustomControlRelationMongoDao.deleteByApplication(appCode);

    }
}
