package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.mongodb.domain.appCustomConfig.CustomControlRelation;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.domain.PageDesignTime;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.service.appCustomConfig.CustomControlEventListener;
import com.digiwin.athena.service.appCustomConfig.event.CustomControlEventManager;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
@Slf4j
public class NewPageDesignEventListener extends CustomControlEventListener {
    @Override
    public void doEvent(Object obj) {
        JSONObject pageDesignJo = (JSONObject) obj;
        PageDesign pageDesign = pageDesignJo.toJavaObject(PageDesign.class);

        List<PageDsl> pageDslList = (List<PageDsl>)pageDesignJo.get("pageDslList");

        String tenantId = CurThreadInfoUtils.getCurTokenTenant().getTenantId();
        Map<String, String> typeMapCode = getTypeMapCodeRes(pageDesignJo.getString("adpApplication"),tenantId );

        for (PageDsl pageDsl : pageDslList) {
            PageDesignTime designTime = pageDsl.getDesignTime();
            if (designTime!=null){
                ArrayList<CustomControlRelation> customControlRelations = new ArrayList<>();
                Collection<String> customControlList = designTime.getCustomControlList().stream().map(c->c.getType()).collect(Collectors.toList());
                for (String control : customControlList) {
                    if (!typeMapCode.containsKey(control)){
                        continue;
                    }

                    CustomControlRelation customControlRelation = new CustomControlRelation();
                    customControlRelation.setName(pageDesign.getName());
                    customControlRelation.setLang(pageDesign.getLang());
                    customControlRelation.setAdpTenantId(tenantId);
                    customControlRelation.setAdpApplication(pageDesign.getAdpApplication());
                    customControlRelation.setTargetCode(pageDesign.getCode());
                    customControlRelation.setUiKey(pageDsl.getCode());
                    customControlRelation.setTargetType(getType().getCode());
                    customControlRelation.setCustomControlType(control);
                    customControlRelation.setSourceCode(typeMapCode.get(control));

                    UserHelper.fillCreateInfo(customControlRelation);
                    UserHelper.fillEditInfo(customControlRelation);
                    customControlRelations.add(customControlRelation);
                }

                if (!customControlRelations.isEmpty()){
                    customControlRelationV2MongoDao.deleteByUiKeyAndTargetCode(pageDsl.getCode(),pageDesign.getCode());
                    customControlRelationV2MongoDao.insertAll(customControlRelations);
                }

            }
        }
    }

    @Override
    protected CustomControlEventManager.EvenType getType() {
        return CustomControlEventManager.EvenType.NEW_PAGE_DESIGN;
    }
}
