package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.base.ErrorCodeConstants;
import com.digiwin.athena.dao.RApplicationCustomConfigMongoDao;
import com.digiwin.athena.dao.RCustomControlRelationMongoDao;
import com.digiwin.athena.dao.UserDefinedCenterMongoDao;
import com.digiwin.athena.domain.UserDefinedCenter;
import com.digiwin.athena.dto.SystemParam;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.mongodb.domain.appCustomConfig.ApplicationCustomConfig;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.dto.PageDesignBusinessDto;
import com.digiwin.athena.dto.PageDesignDto;
import com.digiwin.athena.http.distribution.FxApiHelper;
import com.digiwin.athena.http.distribution.ProgramAuthResDto;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.mysql.domain.user.UserPO;
import com.digiwin.athena.service.MultiPlatformDiffInterface;
import com.digiwin.athena.service.RPageDesignService;
import com.digiwin.athena.service.RPageDslService;
import com.digiwin.athena.service.RuntimeDataQuery;
import com.digiwin.athena.sys.PresetDataServiceV2;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service("pageDesignRuntime")
@Slf4j
public class PageDesignRuntimeDataQuery implements RuntimeDataQuery {

    @Autowired
    private MultiPlatformDiffInterface multiPlatformDiffInterface;
    @Resource
    private RPageDesignService rPageDesignService;
    @Autowired
    private PresetDataServiceV2 presetDataServiceV2;

    @Resource
    private RPageDslService rPageDslService;
    @Autowired
    private RCustomControlRelationMongoDao rCustomControlRelationMongoDao;
    @Autowired
    private RApplicationCustomConfigMongoDao rApplicationCustomConfigMongoDao;
    @Autowired
    private UserDefinedCenterMongoDao userDefinedCenterMongoDao;

    @Override
    public Object queryRuntimeData(JSONObject param) {
        String code = param.getString("code");
        String dslCode = param.getString("dslCode");

        if (StringUtils.isAllBlank(code, dslCode)) {
            throw new BusinessException(ErrorCodeConstants.REQUIRED_PARAM_NOT_EXIST,
                    new Object[]{});
        }
        PageDesignDto pageDesignDto = new PageDesignDto();
        if (StringUtils.isNotEmpty(code)) {
            PageDesign pageDesign = rPageDesignService.queryByCode(code);
            if (pageDesign == null) {
                throw new BusinessException(ErrorCodeConstants.PAGE_DESIGN_NOT_EXIST,
                        new Object[]{code});
            }

            BeanUtils.copyProperties(pageDesign, pageDesignDto);

            // 查询作业权限
            ProgramAuthResDto programAuth = multiPlatformDiffInterface.getProgramAuth(code);
            if (programAuth!=null) {
                if (!Boolean.TRUE.equals(programAuth.getAccessible())) {
                    PresetData presetDataObject = presetDataServiceV2.getPresetDataObject(ErrorCodeConstants.NO_ACCESS_PERMISSION + "");
                    throw new BusinessException(ErrorCodeConstants.NO_ACCESS_PERMISSION,
                            new Object[]{code}, JSONObject.parseObject(presetDataObject.getValue(), PageDesignDto.class));
                }
                // 将权限信息放入返回结果
                pageDesignDto.setAuthInfo(programAuth.getAuthInfo());
            }
        }

        List<SystemParam> sysEnumList = multiPlatformDiffInterface.getSysEnumV2();
        List<JSONObject> sysVariableList = new ArrayList<>();
        for (SystemParam systemParam : sysEnumList) {
            JSONObject variable = new JSONObject();
            variable.put("name", systemParam.getKey());
            variable.put("defaultValue", systemParam.getValue());
            variable.put("scope", "system");
            variable.put("description",systemParam.getDesc());

            sysVariableList.add(variable);
        }

        if (StringUtils.isNotEmpty(dslCode)) {
            PageDsl pageDsl = rPageDslService.queryByCode(dslCode,code);
            if (pageDsl == null) {
                throw new BusinessException(ErrorCodeConstants.PAGE_DSL_NOT_EXIST,
                        new Object[]{code});
            }
            pageDesignDto.setPageDsl(pageDsl);
        } else if (StringUtils.isNotEmpty(pageDesignDto.getDslCode())) {
            PageDsl pageDsl = rPageDslService.queryByCode(pageDesignDto.getDslCode(),pageDesignDto.getCode());
            //主页面dsl没有的话，不抛异常
            pageDesignDto.setPageDsl(pageDsl);
        }
        PageDsl pageDsl = pageDesignDto.getPageDsl();
        pageDsl.getDsl().getVariables().addAll(sysVariableList);

        String pageDesignCode = pageDsl.getPageDesignCode();
        List<String> adpCodes = rCustomControlRelationMongoDao.selectSourceCodeByTargetCode(pageDesignCode);
        if (!adpCodes.isEmpty()){
            List<ApplicationCustomConfig> applicationCustomConfigs = rApplicationCustomConfigMongoDao.selectByAdpCodesAndApp(adpCodes,pageDsl.getAdpApplication());

            pageDesignDto.setApplicationCustomConfigs(applicationCustomConfigs);
        }

        TenantInfo curTokenTenant = CurThreadInfoUtils.getCurTokenTenant();
        UserPO currentUser = UserHelper.getCurrentUser();
        Criteria criteria = Criteria.where("conditions.code").is(pageDsl.getPageDesignCode()).and("conditions.dslCode").is(pageDsl.getCode());
        List<UserDefinedCenter> userDefinedCenters = userDefinedCenterMongoDao.selectAllByUserIdAndTenantId(currentUser.getName(), curTokenTenant.getTenantId(), criteria);
        pageDesignDto.setUserDefinedCenters(userDefinedCenters);


        PresetData presetDataObject = presetDataServiceV2.getPresetDataObject("system_datasource");
        List<String> dataList = (List<String>) presetDataObject.getObj();
        List<JSONObject> res = new ArrayList<>();
        for (String data : dataList) {
            res.add(JSONObject.parseObject(data));
        }
        pageDsl.getDsl().getDataConnectors().addAll(res);

        return pageDesignDto;
    }
}
