package com.digiwin.athena.service.impl;

import com.digiwin.athena.dao.RPageDesignDao;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.service.RPageDesignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Service
public class RPageDesignServiceImpl implements RPageDesignService {

    @Autowired
    private RPageDesignDao rPageDesignDao;

    @Override
    public PageDesign queryByCode(String code) {
        return rPageDesignDao.findByCode(code);
    }

    @Override
    public long deleteByCode(String code) {
        return rPageDesignDao.deleteByCode(code);
    }

    @Override
    public void insert(PageDesign pageDesign) {
        rPageDesignDao.insert(pageDesign);
    }

    @Override
    public List<PageDesign> queryByApplication(String application) {
        return rPageDesignDao.selectByApplication(application);
    }

    @Override
    public List<PageDesign> queryMobileByAppCodes(Collection appCodes) {
        if (CollectionUtils.isEmpty(appCodes)){
            return new ArrayList<>();
        }
        return rPageDesignDao.queryMobileByAppCodes(appCodes);
    }
}