package com.digiwin.athena.service.impl;

import com.digiwin.athena.dao.RPageDslDao;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.service.RPageDslService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RPageDslServiceImpl implements RPageDslService {

    @Autowired
    private RPageDslDao rPageDslDao;

    @Override
    public PageDsl queryByCode(String code,String pageDesignCode) {
        return rPageDslDao.findByCode(code,pageDesignCode);
    }

    @Override
    public long deleteByPageDesignCode(String pageDesignCode) {
        return rPageDslDao.deleteByPageDesignCode(pageDesignCode);
    }

    @Override
    public void insert(PageDsl pageDsl) {
        rPageDslDao.insert(pageDsl);
    }

    @Override
    public void batchInsert(List<PageDsl> pageDslList) {
        rPageDslDao.batchInsert(pageDslList);
    }

} 