package com.digiwin.athena.dao;

import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Slf4j
@Repository
public class RPageDesignDao {

    @Autowired
    private MongoRuntimeRepositoryDecorator mongoRuntimeRepositoryDecorator;

    /**
     * 插入PageDesign
     */
    public void insert(PageDesign pageDesign) {
        mongoRuntimeRepositoryDecorator.insert(pageDesign);
    }

    /**
     * 根据code删除
     */
    public long deleteByCode(String code) {
        Criteria criteria = Criteria.where("code").is(code);
        return mongoRuntimeRepositoryDecorator.remove(new Query(criteria), PageDesign.class);
    }

    /**
     * 更新PageDesign
     */
    public void update(PageDesign pageDesign) {
        mongoRuntimeRepositoryDecorator.save(pageDesign);
    }

    /**
     * 根据code查询
     */
    public PageDesign findByCode(String code) {
        Criteria criteria = Criteria.where("code").is(code);
        return mongoRuntimeRepositoryDecorator.findOne(new Query(criteria), PageDesign.class);
    }

    /**
     * 根据条件查询
     */
    public List<PageDesign> find(Query query) {
        return mongoRuntimeRepositoryDecorator.find(query, PageDesign.class);
    }

    /**
     * 根据条件查询单个
     */
    public PageDesign findOne(Query query) {
        return mongoRuntimeRepositoryDecorator.findOne(query, PageDesign.class);
    }

    /**
     * 删除实体
     */
    public void delete(PageDesign pageDesign) {
        mongoRuntimeRepositoryDecorator.delete(pageDesign);
    }

    public void deleteByCodeAndApplication(String code, String application) {
        Criteria criteria = Criteria.where("code").is(code).and("adpApplication").is(application);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria),PageDesign.class);
    }

    public List<PageDesign> selectByApplication(String application) {
        Criteria criteria = Criteria.where("adpApplication").is(application);
        return mongoRuntimeRepositoryDecorator.find(new Query(criteria),PageDesign.class);
    }

    public Set<String> selectCodeByAdpApplication(String adpApplication) {
        Criteria criteria = Criteria.where("adpApplication").is(adpApplication);
        Query query = new Query(criteria);
        query.fields().include("code");
        return mongoRuntimeRepositoryDecorator.find(query,PageDesign.class).stream().map(PageDesign::getCode).collect(Collectors.toSet());
    }

    public void deleteByCodes(Collection<String> rCodes, String adpApplication) {
        Criteria criteria = Criteria.where("code").in(rCodes).and("adpApplication").is(adpApplication);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria),PageDesign.class);
    }

    public void deleteByApplication(String appCode) {
        Criteria criteria = Criteria.where("adpApplication").is(appCode);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria),PageDesign.class);
    }

    public List<PageDesign> queryMobileByAppCodes(Collection appCodes) {
        Criteria criteria = Criteria.where("adpApplication").in(appCodes).and("isMobile").is(true);
        Query query = new Query(criteria);
        return mongoRuntimeRepositoryDecorator.find(query,PageDesign.class);
    }
}