package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.service.MultiPlatformDiffInterface;
import com.digiwin.athena.service.RPageDesignService;
import com.digiwin.athena.service.RuntimeDataQuery;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service("appMobilePageDesignRuntime")
@Slf4j
public class AppMobilePageDesignRuntimeDataQuery implements RuntimeDataQuery {
    @Autowired
    private RPageDesignService rPageDesignService;
    @Autowired
    private MultiPlatformDiffInterface multiPlatformDiffInterface;
    @Override
    public Object queryRuntimeData(JSONObject param) {
        JSONArray appCodes = param.getJSONArray("appCodes");
        if (!CollectionUtils.isEmpty(appCodes)){
            List<String> appCodesList = appCodes.stream().map(c -> String.valueOf(c)).collect(Collectors.toList());

            List<PageDesign> pageDesignList = rPageDesignService.queryMobileByAppCodes(appCodesList);
            Set<String> codesSet = pageDesignList.stream().map(PageDesign::getCode).collect(Collectors.toSet());
            if (codesSet.isEmpty()){
                return Collections.emptyList();
            }
            Collection<String> authCodes = multiPlatformDiffInterface.getAuthPageDesign(codesSet,appCodesList);

            return pageDesignList.stream().filter(p->authCodes.contains(p.getCode())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}
