package com.digiwin.athena.dao;

import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.mongodb.repository.MongoMultiRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class DPageDslDao {

    @Autowired
    private MongoMultiRepositoryDecorator mongoMultiRepositoryDecorator;

    public void insert(PageDsl pageDsl) {
        mongoMultiRepositoryDecorator.insert(pageDsl);
    }

    public List<PageDsl> selectByPageDesignCode(String pageDesignCode, String application) {
        Criteria criteria = Criteria.where("pageDesignCode").is(pageDesignCode).and("adpApplication").is(application);
        return mongoMultiRepositoryDecorator.find(new Query(criteria), PageDsl.class);
    }

    public PageDsl selectByCodeAndApplication(String code, String pageDesignCode,String application) {
        Criteria criteria = Criteria.where("code").is(code)
                .and("adpApplication").is(application)
                .and("pageDesignCode").is(pageDesignCode);
        return mongoMultiRepositoryDecorator.findOne(new Query(criteria), PageDsl.class);
    }

    public void save(PageDsl pageDsl) {
        mongoMultiRepositoryDecorator.save(pageDsl);
    }

    public void deleteByPageDesignCodeAndApplication(String pageDesignCode, String application) {
        Criteria criteria = Criteria.where("pageDesignCode").is(pageDesignCode).and("adpApplication").is(application);
        mongoMultiRepositoryDecorator.remove(new Query(criteria), PageDsl.class);
    }

    public List<PageDsl> selectBasicByApplication(String application) {
        Criteria criteria = Criteria.where("adpApplication").is(application);
        Query query = new Query(criteria);
        query.with(Sort.by(Sort.Direction.ASC,"type"));
        query.fields().exclude("dsl.layout","dsl.hooks","dsl.rules","dsl.variables","dsl.dataConnectors","dsl.globalSetting","designTime");
        return mongoMultiRepositoryDecorator.find(query, PageDsl.class);
    }

    public List<PageDsl> selectByApplication(String application) {
        Criteria criteria = Criteria.where("adpApplication").is(application);
        Query query = new Query(criteria);
        return mongoMultiRepositoryDecorator.find(query, PageDsl.class);
    }

    public List<PageDsl> selectBasicByPageDesignCodeAndApplication(String code, String application) {
        Criteria criteria = Criteria.where("adpApplication").is(application)
                .and("pageDesignCode").is(code);
        Query query = new Query(criteria);
        query.fields().exclude("dsl", "designTime");
        return mongoMultiRepositoryDecorator.find(query, PageDsl.class);
    }

    public void remove(PageDsl pageDsl) {
        mongoMultiRepositoryDecorator.delete(pageDsl);
    }


    public List<PageDsl> findAll() {
        return mongoMultiRepositoryDecorator.findAll(PageDsl.class);
    }
}
