package com.digiwin.athena.domain;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.Map;

/**
 * 新版页面设计器使用
 * @author Jiangmx
 * @date 2025/6/23
 */
@Data
@Accessors(chain = true)
@Document(collection = "lcdp_pageDesign")
public class PageDesign {

    public static final String BASIC_TABLE_TEMPLATE_TYPE="basic_table";
    public static final String EDITABLE_TABLE_TEMPLATE_TYPE="editable_table";

    @Id
    private String objectId;

    @NotBlank(message = "4003")
    private String code;

    private String name;

    private String templateType;

    private Map<String, MultiLanguageDTO> lang;

    private String dslCode;

    private String adpApplication;

    private String adpTenantId;

    private Date publishedTime;

    private String createBy;
    private Date createDate;
    private String editBy;
    private Date editDate;

    private Boolean isMobile;
}