/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.validate;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@Documented
@Constraint(validatedBy={LangLenValidator.class, MapLangLenValidator.class})
@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Repeatable(value=List.class)
public @interface ValidLangLen {
    public int min() default 0;

    public int max() default 0x7FFFFFFF;

    public String message() default "{org.hibernate.validator.constraints.Length.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class MapLangLenValidator
    extends BaseLangLenValidator<Map<String, MultiLanguageDTO<?>>> {
        private static final String KEY = "name";

        public boolean isValid(Map<String, MultiLanguageDTO<?>> map, ConstraintValidatorContext context) {
            if (map == null || map.isEmpty()) {
                return true;
            }
            MultiLanguageDTO<?> lang = map.get(KEY);
            return this._isValid((builder, fieldName) -> builder.addPropertyNode(fieldName).inContainer(Map.class, Integer.valueOf(1)).inIterable().atKey((Object)KEY), lang, context);
        }
    }

    public static class LangLenValidator
    extends BaseLangLenValidator<MultiLanguageDTO<?>> {
        public boolean isValid(MultiLanguageDTO lang, ConstraintValidatorContext context) {
            return this._isValid(ConstraintValidatorContext.ConstraintViolationBuilder::addPropertyNode, lang, context);
        }
    }

    public static abstract class BaseLangLenValidator<T>
    implements ConstraintValidator<ValidLangLen, T> {
        protected int min;
        protected int max;

        public void initialize(ValidLangLen constraintAnnotation) {
            this.min = constraintAnnotation.min();
            this.max = constraintAnnotation.max();
        }

        protected boolean judgeLen(Consumer<String> notValidCallback, MultiLanguageDTO<?> lang) {
            if (lang == null) {
                return true;
            }
            boolean isValid = true;
            if (lang.getZh_CN() != null && this.notBetween(String.valueOf(lang.getZh_CN()).length(), this.min, this.max)) {
                notValidCallback.accept("zh_CN");
                isValid = false;
            }
            if (lang.getEn_US() != null && this.notBetween(String.valueOf(lang.getEn_US()).length(), this.min, this.max)) {
                notValidCallback.accept("en_US");
                isValid = false;
            }
            if (lang.getZh_TW() != null && this.notBetween(String.valueOf(lang.getZh_TW()).length(), this.min, this.max)) {
                notValidCallback.accept("zh_TW");
                isValid = false;
            }
            return isValid;
        }

        protected boolean notBetween(int value, int min, int max) {
            return value < min || value > max;
        }

        protected boolean _isValid(BiConsumer<ConstraintValidatorContext.ConstraintViolationBuilder, String> notValidCallback, MultiLanguageDTO<?> lang, ConstraintValidatorContext context) {
            ConstraintValidatorContext.ConstraintViolationBuilder builder = context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate());
            boolean isValid = this.judgeLen(fieldName -> notValidCallback.accept(builder, (String)fieldName), lang);
            if (!isValid) {
                context.disableDefaultConstraintViolation();
                builder.addConstraintViolation();
            }
            return isValid;
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public ValidLangLen[] value();
    }
}

