/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.mongodb.repository.MongoMultiRepositoryDecorator;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DPageDslDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DPageDslDao.class);
    @Autowired
    private MongoMultiRepositoryDecorator mongoMultiRepositoryDecorator;

    public void insert(PageDsl pageDsl) {
        this.mongoMultiRepositoryDecorator.insert((Object)pageDsl);
    }

    public List<PageDsl> selectByPageDesignCode(String pageDesignCode, String application) {
        Criteria criteria = Criteria.where((String)"pageDesignCode").is((Object)pageDesignCode).and("adpApplication").is((Object)application);
        return this.mongoMultiRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), PageDsl.class);
    }

    public PageDsl selectByCodeAndApplication(String code, String pageDesignCode, String application) {
        Criteria criteria = Criteria.where((String)"code").is((Object)code).and("adpApplication").is((Object)application).and("pageDesignCode").is((Object)pageDesignCode);
        return (PageDsl)((Object)this.mongoMultiRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), PageDsl.class));
    }

    public void save(PageDsl pageDsl) {
        this.mongoMultiRepositoryDecorator.save((Object)pageDsl);
    }

    public void deleteByPageDesignCodeAndApplication(String pageDesignCode, String application) {
        Criteria criteria = Criteria.where((String)"pageDesignCode").is((Object)pageDesignCode).and("adpApplication").is((Object)application);
        this.mongoMultiRepositoryDecorator.remove(new Query((CriteriaDefinition)criteria), PageDsl.class);
    }

    public List<PageDsl> selectBasicByApplication(String application) {
        Criteria criteria = Criteria.where((String)"adpApplication").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"type"}));
        query.fields().exclude(new String[]{"dsl.layout", "dsl.hooks", "dsl.rules", "dsl.variables", "dsl.dataConnectors", "dsl.globalSetting", "designTime"});
        return this.mongoMultiRepositoryDecorator.find(query, PageDsl.class);
    }

    public List<PageDsl> selectByApplication(String application) {
        Criteria criteria = Criteria.where((String)"adpApplication").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoMultiRepositoryDecorator.find(query, PageDsl.class);
    }

    public List<PageDsl> selectBasicByPageDesignCodeAndApplication(String code, String application) {
        Criteria criteria = Criteria.where((String)"adpApplication").is((Object)application).and("pageDesignCode").is((Object)code);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().exclude(new String[]{"dsl", "designTime"});
        return this.mongoMultiRepositoryDecorator.find(query, PageDsl.class);
    }

    public void remove(PageDsl pageDsl) {
        this.mongoMultiRepositoryDecorator.delete((Object)pageDsl);
    }

    public List<PageDsl> findAll() {
        return this.mongoMultiRepositoryDecorator.findAll(PageDsl.class);
    }
}

