/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.publish;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.dao.CustomControlRelationV2MongoDao;
import com.digiwin.athena.dao.DPageDesignDao;
import com.digiwin.athena.dao.DPageDslDao;
import com.digiwin.athena.dao.RCustomControlRelationMongoDao;
import com.digiwin.athena.dao.RPageDesignDao;
import com.digiwin.athena.dao.RPageDslDao;
import com.digiwin.athena.domain.DeployDetail;
import com.digiwin.athena.domain.PageDesign;
import com.digiwin.athena.domain.PageDsl;
import com.digiwin.athena.dto.BusinessDto;
import com.digiwin.athena.dto.DeployDataDto;
import com.digiwin.athena.dto.PageDesignBusinessDto;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.appCustomConfig.CustomControlRelation;
import com.digiwin.athena.publish.Publish;
import com.digiwin.athena.publish.PublishExtendOperationWrapper;
import com.digiwin.athena.publish.dto.PublishParam;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=100)
public class PageDesignPublish
extends Publish<PageDesignBusinessDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageDesignPublish.class);
    @Autowired
    private DPageDesignDao dPageDesignDao;
    @Autowired
    private DPageDslDao dPageDslDao;
    @Autowired
    private RPageDesignDao rPageDesignDao;
    @Autowired
    private RPageDslDao rPageDslDao;
    @Autowired
    private CustomControlRelationV2MongoDao customControlRelationV2MongoDao;
    @Autowired
    private RCustomControlRelationMongoDao rCustomControlRelationMongoDao;
    @Autowired
    @Qualifier(value="pageDesignExtendWrapper")
    private PublishExtendOperationWrapper<PageDesignBusinessDto> publishExtendOperationWrapper;

    public List<PageDesignBusinessDto> doCompile(List<PageDesignBusinessDto> data) {
        if (CollectionUtil.isEmpty(data)) {
            return data;
        }
        return this.publishExtendOperationWrapper.doCompile(data);
    }

    public PageDesignBusinessDto preHandle(PageDesignBusinessDto publishData) {
        return publishData;
    }

    public PageDesignBusinessDto postHandle(PageDesignBusinessDto publishData) {
        PageDesign pageDesign = publishData.getPageDesign();
        this.dPageDesignDao.updatePublishedTime(pageDesign.getCode(), pageDesign.getAdpApplication(), new Date());
        return (PageDesignBusinessDto)this.publishExtendOperationWrapper.postHandle((BusinessDto)publishData);
    }

    void deleteRuntimeData(DeployDataDto<PageDesignBusinessDto> deployDataDto) {
        List publishDataList = deployDataDto.getPublishData();
        for (PageDesignBusinessDto pageDesignBusinessDto : publishDataList) {
            this.deleteSingleRuntimeData(pageDesignBusinessDto);
        }
    }

    public List<PageDesignBusinessDto> findAllPublishData(PublishParam publishParam) {
        ArrayList<PageDesignBusinessDto> res = new ArrayList<PageDesignBusinessDto>();
        List<PageDesign> pageDesignList = this.dPageDesignDao.selectByApplication(publishParam.getApplication());
        List<PageDsl> pageDslList = this.dPageDslDao.selectByApplication(publishParam.getApplication());
        pageDslList.forEach(p -> p.setObjectId(null));
        Map<String, List<PageDsl>> pageDslMap = pageDslList.stream().collect(Collectors.groupingBy(PageDsl::getPageDesignCode));
        for (PageDesign pageDesign : pageDesignList) {
            PageDesignBusinessDto pageDesignBusinessDto = new PageDesignBusinessDto();
            res.add(pageDesignBusinessDto);
            pageDesign.setObjectId(null);
            pageDesignBusinessDto.setPageDesign(pageDesign);
            if (pageDslMap.containsKey(pageDesign.getCode())) {
                pageDesignBusinessDto.setPageDslList(pageDslMap.get(pageDesign.getCode()));
            }
            List customControlRelations = this.customControlRelationV2MongoDao.selectByTargetCodeAndApplication(pageDesign.getCode(), publishParam.getApplication());
            customControlRelations.forEach(c -> c.setObjectId(null));
            pageDesignBusinessDto.setControlRelations(customControlRelations);
        }
        return res;
    }

    void insertSingleRuntimeData(PageDesignBusinessDto publishData) {
        List<CustomControlRelation> controlRelations;
        this.rPageDesignDao.insert(publishData.getPageDesign());
        List<PageDsl> pageDslList = publishData.getPageDslList();
        if (!pageDslList.isEmpty()) {
            this.rPageDslDao.insertAll(pageDslList);
        }
        if (!(controlRelations = publishData.getControlRelations()).isEmpty()) {
            this.rCustomControlRelationMongoDao.insertAll(controlRelations);
        }
    }

    void deleteSingleRuntimeData(PageDesignBusinessDto publishData) {
        PageDesign pageDesign = publishData.getPageDesign();
        this.rPageDesignDao.deleteByCodeAndApplication(pageDesign.getCode(), pageDesign.getAdpApplication());
        this.rPageDslDao.deleteByPageDesignCodes(Arrays.asList(pageDesign.getCode()), pageDesign.getAdpApplication());
        this.rCustomControlRelationMongoDao.deleteByTargetCodeAndApp(pageDesign.getCode(), pageDesign.getAdpApplication());
    }

    PageDesignBusinessDto findSinglePublishData(PublishParam publishParam) {
        PageDesign pageDesign = this.dPageDesignDao.selectByCodeAndApplication(publishParam.getCode(), publishParam.getApplication());
        Assert.notNull((Object)pageDesign, (String)(publishParam.getCode() + "\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8bb0\u5f55"));
        pageDesign.setObjectId(null);
        List<PageDsl> pageDsls = this.dPageDslDao.selectByPageDesignCode(pageDesign.getCode(), publishParam.getApplication());
        pageDsls.forEach(p -> p.setObjectId(null));
        PageDesignBusinessDto res = new PageDesignBusinessDto();
        res.setPageDesign(pageDesign);
        res.setPageDslList(pageDsls);
        List customControlRelations = this.customControlRelationV2MongoDao.selectByTargetCodeAndApplication(pageDesign.getCode(), publishParam.getApplication());
        customControlRelations.forEach(c -> c.setObjectId(null));
        res.setControlRelations(customControlRelations);
        return res;
    }

    public DeployDetail.DetailContent getDeployDetailContent(PageDesignBusinessDto data) {
        MultiLanguageDTO multiLanguageDTO;
        DeployDetail.DetailContent detailContent = new DeployDetail.DetailContent();
        PageDesign pageDesign = data.getPageDesign();
        String content = "\u4f5c\u4e1a\u53d1\u5e03:" + pageDesign.getName();
        String langStr = "{\"content\":{\"en_US\":\"Job Posting:%s\",\"zh_CN\":\"\u4f5c\u4e1a\u53d1\u5e03:%s\",\"zh_TW\":\"\u4f5c\u696d\u767c\u5e03:%s\"}}";
        Map<String, MultiLanguageDTO> languageDTOMap = pageDesign.getLang();
        if (!CollectionUtil.isEmpty(languageDTOMap) && languageDTOMap.containsKey("name") && (multiLanguageDTO = languageDTOMap.get("name")) != null) {
            langStr = String.format(langStr, multiLanguageDTO.getEn_US(), multiLanguageDTO.getZh_CN(), multiLanguageDTO.getZh_TW());
        }
        detailContent.setContent(content);
        detailContent.setResult("start");
        detailContent.setClassName(((Object)((Object)this)).getClass().getName());
        Map lang = (Map)JSONObject.parseObject((String)langStr, (TypeReference)new TypeReference<Map<String, MultiLanguageDTO>>(){}, (Feature[])new Feature[0]);
        detailContent.setLang(lang);
        return detailContent;
    }

    public void endPostHandle(DeployDataDto<PageDesignBusinessDto> deployDataDto) {
        List publishDataList = deployDataDto.getPublishData();
        Set codes = publishDataList.stream().map(p -> p.getPageDesign().getCode()).collect(Collectors.toSet());
        Set<String> rCodes = this.rPageDesignDao.selectCodeByAdpApplication(deployDataDto.getAdpApplication());
        rCodes.removeAll(codes);
        this.rPageDslDao.deleteByPageDesignCodes(rCodes, deployDataDto.getAdpApplication());
        this.rPageDesignDao.deleteByCodes(rCodes, deployDataDto.getAdpApplication());
        this.rCustomControlRelationMongoDao.deleteByTargetCodesAndApp(rCodes, deployDataDto.getAdpApplication());
        this.publishExtendOperationWrapper.endPostHandle(deployDataDto);
    }

    public List<PageDesignBusinessDto> jsonStrToObject(String jsonStr) {
        return JSONObject.parseArray((String)jsonStr, PageDesignBusinessDto.class);
    }
}

