/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.impl;

import cn.hutool.core.util.IdUtil;
import com.digiwin.athena.dao.FileStoreMongoDao;
import com.digiwin.athena.domain.FileStore;
import com.digiwin.athena.dto.FxUploadFileAResDto;
import com.digiwin.athena.http.distribution.FxApiHelper;
import com.digiwin.athena.http.distribution.UploadFileResDto;
import com.digiwin.athena.http.distribution.UploadParamDto;
import com.digiwin.athena.service.FileStoreService;
import com.digiwin.athena.utils.GzipUtil;
import com.digiwin.athena.utils.MD5Util;
import com.digiwin.athena.utils.user.UserHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileStoreServiceImpl
implements FileStoreService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileStoreServiceImpl.class);
    private static final Integer CHUNK_SIZE = 0xF00000;
    @Autowired
    private FileStoreMongoDao fileStoreMongoDao;
    @Autowired
    private FxApiHelper fxApiHelper;

    @Override
    public String fxUploadFile(final MultipartFile file, String tableNo, String dslCode) throws IOException {
        UploadParamDto uploadParamDto = new UploadParamDto();
        ByteArrayResource byteArrayResource = new ByteArrayResource(file.getBytes()){

            public String getFilename() {
                return file.getOriginalFilename();
            }
        };
        uploadParamDto.setAttach(byteArrayResource);
        uploadParamDto.setTableNo(tableNo);
        uploadParamDto.setDocumentNo(dslCode);
        UploadFileResDto res = this.fxApiHelper.upload(uploadParamDto);
        return res.getUrl();
    }

    @Override
    public FxUploadFileAResDto fxUploadFileA(final MultipartFile file, String programCode) throws IOException {
        UploadParamDto uploadParamDto = new UploadParamDto();
        ByteArrayResource byteArrayResource = new ByteArrayResource(file.getBytes()){

            public String getFilename() {
                return file.getOriginalFilename();
            }
        };
        uploadParamDto.setAttach(byteArrayResource);
        uploadParamDto.setProgramCode(programCode);
        UploadFileResDto uploadFileResDto = this.fxApiHelper.fxUploadFile(uploadParamDto);
        FxUploadFileAResDto res = new FxUploadFileAResDto();
        res.setSize(uploadFileResDto.getFileSize());
        res.setUrl(uploadFileResDto.getUrl());
        res.setName(uploadFileResDto.getFileName());
        res.setFileId(uploadFileResDto.getId());
        res.setFileType(uploadFileResDto.getFileType());
        return res;
    }

    @Override
    public String uploadFile(InputStream inputStream, String fileName, String fileType) {
        try {
            String string;
            String fileHash;
            byte[] byteArray;
            ByteArrayOutputStream outputStream;
            block20: {
                int bytesRead;
                byte[] buffer = new byte[8192];
                outputStream = new ByteArrayOutputStream();
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                byteArray = outputStream.toByteArray();
                ByteArrayInputStream stream1 = new ByteArrayInputStream(byteArray);
                fileHash = MD5Util.getFileHash((InputStream)stream1);
                FileStore existFileStore = this.fileStoreMongoDao.selectFileBasicInfoByMD5(fileHash);
                if (existFileStore == null) break block20;
                Long count = this.fileStoreMongoDao.selectExistByMD5(fileHash);
                if (!existFileStore.getDataSheet().equals(count.intValue())) break block20;
                String string2 = existFileStore.getFileId();
                outputStream.close();
                return string2;
            }
            try {
                byte[] compress = GzipUtil.compress((byte[])byteArray);
                List<byte[]> contentArr = FileStoreServiceImpl.splitByteArray(compress);
                String fileId = IdUtil.fastSimpleUUID();
                for (int i = 0; i < contentArr.size(); ++i) {
                    byte[] c = contentArr.get(i);
                    FileStore fileStore = new FileStore();
                    fileStore.setFileId(fileId);
                    fileStore.setFileName(fileName);
                    fileStore.setDataSheet(contentArr.size());
                    fileStore.setFileType(fileType);
                    fileStore.setContent(c);
                    fileStore.setOrder(i);
                    fileStore.setMd5(fileHash);
                    UserHelper.fillEditInfo((Object)fileStore);
                    UserHelper.fillCreateInfo((Object)fileStore);
                    this.fileStoreMongoDao.insert(fileStore);
                }
                string = fileId;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25:" + e.getMessage(), (Throwable)e);
                    throw new RuntimeException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
                }
            }
            outputStream.close();
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public FileStore getFile(String fileId) throws IOException {
        List<FileStore> fileStores = this.fileStoreMongoDao.selectByFileId(fileId);
        Assert.isTrue((!fileStores.isEmpty() ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6587\u4ef6");
        int totalLength = 0;
        for (FileStore fileStore : fileStores) {
            totalLength += fileStore.getContent().length;
        }
        byte[] result = new byte[totalLength];
        int currentPos = 0;
        for (FileStore fs : fileStores) {
            byte[] content = fs.getContent();
            if (content == null) continue;
            System.arraycopy(content, 0, result, currentPos, content.length);
            currentPos += content.length;
        }
        byte[] decompress = GzipUtil.decompress((byte[])result);
        FileStore old = fileStores.get(0);
        FileStore fileStore = new FileStore();
        fileStore.setFileName(old.getFileName());
        fileStore.setFileType(old.getFileType());
        fileStore.setFileId(old.getFileId());
        fileStore.setContent(decompress);
        return fileStore;
    }

    public static List<byte[]> splitByteArray(byte[] data) {
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        int offset = 0;
        while (offset < data.length) {
            int end = Math.min(offset + CHUNK_SIZE, data.length);
            byte[] chunk = Arrays.copyOfRange(data, offset, end);
            chunks.add(chunk);
            offset = end;
        }
        return chunks;
    }
}

