/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.utils.pageDesignModel;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.constant.modelDriven.BusinessDirEnum;
import com.digiwin.athena.domain.modeldesign.BusinessDirTreeInfo;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class BusinessResourceTreeUtil {
    public static final String OTHER = "\u5176\u4ed6";
    public static final String OTHER_EN = "other";
    public static final String BN = "BN";
    public static final String UNDERLINE = "_";

    public static void sortBusinessDirTree(List<BusinessDirTreeInfo> businessDirTree) {
        businessDirTree.sort(new Comparator<BusinessDirTreeInfo>(){

            @Override
            public int compare(BusinessDirTreeInfo o1, BusinessDirTreeInfo o2) {
                int index1 = this.getTypeIndex(o1.getType());
                int index2 = this.getTypeIndex(o2.getType());
                return Integer.compare(index1, index2);
            }

            private int getTypeIndex(String type) {
                switch (type) {
                    case "modelDesign": {
                        return 0;
                    }
                    case "dataView": {
                        return 1;
                    }
                    case "homeWork": {
                        return 2;
                    }
                    case "event": {
                        return 3;
                    }
                    case "service": {
                        return 4;
                    }
                    case "businessProcess": {
                        return 5;
                    }
                    case "detect": {
                        return 6;
                    }
                }
                return Integer.MAX_VALUE;
            }
        });
    }

    public static Query buildQuery(String fieldName, Object value) {
        Criteria criteria = Criteria.where((String)fieldName).is(value);
        return Query.query((CriteriaDefinition)criteria);
    }

    public static BusinessDirTreeInfo getDuoLanBusinessPageDesign(String pageDesignCode, String businessCode, String serviceCode, Map<String, Map<String, MultiLanguageDTO>> businessSubNameLang) {
        return new BusinessDirTreeInfo().setBusinessSubCode(pageDesignCode).setLang(businessSubNameLang.get(BusinessDirEnum.DATA_ENTRY_DESIGN.getType())).setBusinessSubName(BusinessDirEnum.DATA_ENTRY_DESIGN.getName()).setType(BusinessDirEnum.DATA_ENTRY_DESIGN.getType()).setPath(BusinessDirEnum.PAGE_DESIGN.getPath() + businessCode + "/" + pageDesignCode + BusinessDirEnum.DATA_ENTRY_DESIGN.getSubPath()).setServiceCode(serviceCode);
    }

    public static BusinessDirTreeInfo getBrownBusinessPageDesign(String pageDesignCode, String businessCode, String serviceCode, Map<String, Map<String, MultiLanguageDTO>> businessSubNameLang) {
        return new BusinessDirTreeInfo().setBusinessSubCode(pageDesignCode).setLang(businessSubNameLang.get(BusinessDirEnum.DATA_ENTRY_BROWSE.getType())).setBusinessSubName(BusinessDirEnum.DATA_ENTRY_BROWSE.getName()).setType(BusinessDirEnum.DATA_ENTRY_BROWSE.getType()).setPath(BusinessDirEnum.PAGE_DESIGN.getPath() + businessCode + "/" + pageDesignCode + BusinessDirEnum.DATA_ENTRY_BROWSE.getSubPath()).setServiceCode(serviceCode);
    }

    public static BusinessDirTreeInfo getEditBusinessPageDesign(String pageDesignCode, String businessCode, String serviceCode, Map<String, Map<String, MultiLanguageDTO>> businessSubNameLang) {
        return new BusinessDirTreeInfo().setBusinessSubCode(pageDesignCode).setBusinessSubName(BusinessDirEnum.DATA_ENTRY_EDIT.getName()).setLang(businessSubNameLang.get(BusinessDirEnum.DATA_ENTRY_EDIT.getType())).setType(BusinessDirEnum.DATA_ENTRY_EDIT.getType()).setPath(BusinessDirEnum.PAGE_DESIGN.getPath() + businessCode + "/" + pageDesignCode + BusinessDirEnum.DATA_ENTRY_EDIT.getSubPath()).setServiceCode(serviceCode);
    }

    public static Map<String, MultiLanguageDTO> handleModelMultiLang(JSONObject lang) {
        if (Objects.nonNull(lang) && lang.getJSONObject("name") != null) {
            JSONObject nameLang = lang.getJSONObject("name");
            MultiLanguageDTO multiLanguageDTO = new MultiLanguageDTO();
            multiLanguageDTO.setZh_CN((Object)nameLang.getString("zh_CN"));
            multiLanguageDTO.setZh_TW((Object)nameLang.getString("zh_TW"));
            multiLanguageDTO.setEn_US((Object)nameLang.getString("en_US"));
            HashMap<String, MultiLanguageDTO> langTableName = new HashMap<String, MultiLanguageDTO>();
            langTableName.put("modelName", multiLanguageDTO);
            langTableName.put("businessSubName", multiLanguageDTO);
            return langTableName;
        }
        return null;
    }
}

