/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dao.UserDefinedCenterMongoDao;
import com.digiwin.athena.domain.UserDefinedCenter;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.mysql.domain.user.UserPO;
import com.digiwin.athena.service.RuntimeDataQuery;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;

@Service(value="userDefinedCenterRuntime")
public class UserDefinedCenterRuntimeDataQuery
implements RuntimeDataQuery<UserDefinedCenter> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserDefinedCenterRuntimeDataQuery.class);
    @Autowired
    private UserDefinedCenterMongoDao userDefinedCenterMongoDao;

    public UserDefinedCenter queryRuntimeData(JSONObject param) {
        TenantInfo curTokenTenant = CurThreadInfoUtils.getCurTokenTenant();
        UserPO currentUser = UserHelper.getCurrentUser();
        JSONObject conditions = param.getJSONObject("conditions");
        Criteria criteria = null;
        if (conditions != null) {
            criteria = new Criteria();
            for (Map.Entry en : conditions.entrySet()) {
                criteria.and("conditions." + (String)en.getKey()).is(en.getValue());
            }
        }
        UserDefinedCenter userDefinedCenter = this.userDefinedCenterMongoDao.selectByUserIdAndTenantId(currentUser.getName(), curTokenTenant.getTenantId(), criteria);
        return userDefinedCenter;
    }

    public void saveRuntimeData(JSONObject param) {
        TenantInfo curTokenTenant = CurThreadInfoUtils.getCurTokenTenant();
        UserPO currentUser = UserHelper.getCurrentUser();
        UserDefinedCenter userDefinedCenter = this.queryRuntimeData(param);
        if (userDefinedCenter == null) {
            userDefinedCenter = new UserDefinedCenter();
            userDefinedCenter.setUserId(currentUser.getName());
            userDefinedCenter.setTenantId(curTokenTenant.getTenantId());
            userDefinedCenter.setConditions(param.getJSONObject("conditions"));
            userDefinedCenter.setBizCode(param.getString("bizCode"));
            userDefinedCenter.setType(param.getString("type"));
            UserHelper.fillCreateInfo((Object)userDefinedCenter);
        }
        userDefinedCenter.setSettings(param.getJSONObject("settings"));
        UserHelper.fillEditInfo((Object)userDefinedCenter);
        if (StringUtils.isEmpty((CharSequence)userDefinedCenter.getObjId())) {
            this.userDefinedCenterMongoDao.insert(userDefinedCenter);
        } else {
            this.userDefinedCenterMongoDao.save(userDefinedCenter);
        }
    }

    public void deleteRuntimeData(JSONObject param) {
        UserDefinedCenter userDefinedCenter = this.queryRuntimeData(param);
        if (userDefinedCenter != null) {
            this.userDefinedCenterMongoDao.delete(userDefinedCenter);
        }
    }
}

