package com.digiwin.athena.service.codeStandard.impl;

import com.digiwin.athena.service.codeStandard.CodeGenerateHandler;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 *  生成code的规则--->  返回当前的应用缩写,取规则里面的配置
 */
@Service("abbreviationCodeGenerateHandler")
public class AbbreviationCodeGenerateHandler implements CodeGenerateHandler {

    /**
     * 返回当前的应用缩写
     *
     * @param ruleParams 配置的规则
     * @param paramMap paramMap
     */
    @Override
    public String generateCode(Map<String, String> ruleParams, Map<String, String> paramMap) {
        StringBuilder finalCode = new StringBuilder();

        // 遍历 ruleParams 的键
        for (String key : ruleParams.keySet()) {
            // 仅当 key 存在于 paramMap 中时
            if (paramMap.containsKey(key)) {
                String value = ruleParams.get(key);
                if (value != null) {
                    finalCode.append(value);
                }
            }
        }

        return finalCode.toString();
    }


}
