package com.digiwin.athena.service.appCustomConfig.event;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.service.appCustomConfig.CustomControlEventListener;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@Slf4j
public class CustomControlEventManager {
    private static Map<EvenType, List<CustomControlEventListener>> listeners = new HashMap<>();

    public CustomControlEventManager() {
        for (EvenType value : EvenType.values()) {
            listeners.put(value, new ArrayList<>());
        }
    }

    public void registerListener(EvenType type, CustomControlEventListener customControlEventListener) {
        if (listeners.containsKey(type)) {
            listeners.get(type).add(customControlEventListener);
        } else {
            throw new BusinessException(type + " not exists");
        }
    }

    public void notify(EvenType type, Object obj) {
        if (obj==null){
            return;
        }
        if (StringUtils.isEmpty(CurThreadInfoUtils.getTemplateId())) {
            for (CustomControlEventListener customControlEventListener : listeners.get(type)) {
                customControlEventListener.doEvent(obj);
            }
        }
    }

    public enum EvenType {
        PROJECT("Project"),
        TASK("Task"),
        DATA_ENTRY("DataEntry"),
        REPORT("Report"),
        PROCESS("Process"),
        NEW_PAGE_DESIGN("NewPageDesign");
        private String code;

        EvenType(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }
    }
}
