package com.digiwin.athena.actuator;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.http.esp.EspApiHelper;
import com.digiwin.athena.http.esp.EspParamDto;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.JSUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class EspActuator {

    @Autowired
    private EspApiHelper espApiHelper;

    public Object execute(EspExecuteConfig config, Map<String, Object> requestParams) {

        if (!StringUtils.isEmpty(config.getRequestScript())) {
            requestParams = JSUtil.evalRequest(config.getRequestScript(), JSONObject.toJSONString(requestParams), Map.class);
        }

        TenantInfo curTokenTenant = CurThreadInfoUtils.getCurTokenTenant();
        EspParamDto<Object> res = espApiHelper.callEspService(requestParams, config.getEspActionId(), CurThreadInfoUtils.getToken(), curTokenTenant.getTenantId(), config.getServiceCode());

        if (!StringUtils.isEmpty(config.getResponseScript())) {
            return JSUtil.evalResponse(config.getResponseScript(), JSONObject.toJSONString(res), Map.class);
        }
        return res;
    }
}
