package com.digiwin.athena.utils.pageDesignModel;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.constant.modelDriven.BusinessDirEnum;
import com.digiwin.athena.domain.modeldesign.BusinessDirTreeInfo;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import java.util.*;

public class BusinessResourceTreeUtil {


    public static final  String OTHER = "其他";

    public static final  String OTHER_EN = "other";

    public static final String BN = "BN";

    public static final String UNDERLINE = "_";



    /**
     * 排序 模型 -> 查询方案 -> 作业 -> 事件 -> 服务 -> 流程 -> 侦测
     *
     * @param businessDirTree businessDirTree
     */
    public static void sortBusinessDirTree(List<BusinessDirTreeInfo> businessDirTree) {
        businessDirTree.sort(new Comparator<BusinessDirTreeInfo>() {
            @Override
            public int compare(BusinessDirTreeInfo o1, BusinessDirTreeInfo o2) {

                int index1 = getTypeIndex(o1.getType());
                int index2 = getTypeIndex(o2.getType());

                return Integer.compare(index1, index2);
            }

            private int getTypeIndex(String type) {
                switch (type) {
                    case BusinessDirEnum.MODEL_DESIGN_CODE:
                        return 0;
                    case BusinessDirEnum.DATA_VIEW_CODE:
                        return 1;
                    case BusinessDirEnum.JOB_CODE:
                        return 2;
                    case BusinessDirEnum.EVENT_CODE:
                        return 3;
                    case BusinessDirEnum.SERVICE_CODE:
                        return 4;
                    case BusinessDirEnum.BUSINESS_PROCESS_CODE:
                        return 5;
                    case BusinessDirEnum.MONITOR_CODE:
                        return 6;
                    default:
                        return Integer.MAX_VALUE;
                }
            }
        });
    }



    /**
     * 构建公共查询query
     *
     * @param fieldName 查询的字段
     * @param value 匹配的值
     */
    public static Query buildQuery(String fieldName, Object value) {
        Criteria criteria = Criteria.where(fieldName).is(value);
        return Query.query(criteria);
    }

    /**
     * 多栏
     *
     * @param pageDesignCode 作业code
     * @param businessCode 业务code
     * @param serviceCode serviceCode
     * @param businessSubNameLang 多语言
     * @return A {@link BusinessDirTreeInfo}
     */
    public static BusinessDirTreeInfo getDuoLanBusinessPageDesign(String pageDesignCode, String businessCode,
        String serviceCode, Map<String, Map<String, MultiLanguageDTO>> businessSubNameLang) {
        return new BusinessDirTreeInfo().setBusinessSubCode(pageDesignCode)
            .setLang(businessSubNameLang.get(BusinessDirEnum.DATA_ENTRY_DESIGN.getType()))
            .setBusinessSubName(BusinessDirEnum.DATA_ENTRY_DESIGN.getName())
            .setType(BusinessDirEnum.DATA_ENTRY_DESIGN.getType()).setPath(BusinessDirEnum.PAGE_DESIGN.getPath()
                + businessCode + "/" + pageDesignCode + BusinessDirEnum.DATA_ENTRY_DESIGN.getSubPath())
            .setServiceCode(serviceCode);
    }

    /**
     * 作业浏览
     *
     * @param pageDesignCode 作业code
     * @param businessCode 业务code
     * @param serviceCode 服务code
     * @param businessSubNameLang 多语言
     * @return A {@link BusinessDirTreeInfo}
     */
    public static BusinessDirTreeInfo getBrownBusinessPageDesign(String pageDesignCode, String businessCode,
        String serviceCode, Map<String, Map<String, MultiLanguageDTO>> businessSubNameLang) {
        return new BusinessDirTreeInfo().setBusinessSubCode(pageDesignCode)
            .setLang(businessSubNameLang.get(BusinessDirEnum.DATA_ENTRY_BROWSE.getType()))
            .setBusinessSubName(BusinessDirEnum.DATA_ENTRY_BROWSE.getName())
            .setType(BusinessDirEnum.DATA_ENTRY_BROWSE.getType()).setPath(BusinessDirEnum.PAGE_DESIGN.getPath()
                + businessCode + "/" + pageDesignCode + BusinessDirEnum.DATA_ENTRY_BROWSE.getSubPath())
            .setServiceCode(serviceCode);
    }

    /**
     * 作业编辑
     *
     * @param pageDesignCode 作业code
     * @param businessCode 业务code
     * @param serviceCode serviceCode
     * @param businessSubNameLang 多语言
     * @return A {@link BusinessDirTreeInfo}
     */
    public static BusinessDirTreeInfo getEditBusinessPageDesign(String pageDesignCode, String businessCode,
        String serviceCode, Map<String, Map<String, MultiLanguageDTO>> businessSubNameLang) {
        return new BusinessDirTreeInfo().setBusinessSubCode(pageDesignCode)
            .setBusinessSubName(BusinessDirEnum.DATA_ENTRY_EDIT.getName())
            .setLang(businessSubNameLang.get(BusinessDirEnum.DATA_ENTRY_EDIT.getType()))
            .setType(BusinessDirEnum.DATA_ENTRY_EDIT.getType()).setPath(BusinessDirEnum.PAGE_DESIGN.getPath()
                + businessCode + "/" + pageDesignCode + BusinessDirEnum.DATA_ENTRY_EDIT.getSubPath())
            .setServiceCode(serviceCode);
    }

    public static Map<String, MultiLanguageDTO> handleModelMultiLang(JSONObject lang) {
        if (Objects.nonNull(lang) && lang.getJSONObject("name") != null) {
            JSONObject nameLang = lang.getJSONObject("name");
            MultiLanguageDTO multiLanguageDTO = new MultiLanguageDTO();
            multiLanguageDTO.setZh_CN(nameLang.getString("zh_CN"));
            multiLanguageDTO.setZh_TW(nameLang.getString("zh_TW"));
            multiLanguageDTO.setEn_US(nameLang.getString("en_US"));
            Map<String, MultiLanguageDTO> langTableName = new HashMap<>();
            langTableName.put("modelName", multiLanguageDTO);
            langTableName.put("businessSubName", multiLanguageDTO);
            return langTableName;
        }
        return null;
    }

}
