package com.digiwin.athena.controller;

import com.digiwin.athena.dto.FxUserInfoDto;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.http.distribution.FxUser;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.JwtUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/fxUser")
@Tag(name="分销用户接口",description = "d7d50af2-d2eb-4893-bb15-41c377f2a41e")
public class FxUserController {

    @GetMapping("/getUserInfo")
    public ResultDto<FxUserInfoDto> getUserInfo(){
        Jws<Claims> claimsJws = JwtUtil.parseToken(CurThreadInfoUtils.getToken());
        FxUser fxUser = FxUser.create(claimsJws);
        FxUserInfoDto res = FxUserInfoDto.create(fxUser);
        return ResultDto.createSuccess(res);
    }
}
