package com.digiwin.athena.controller;

import cn.hutool.extra.spring.SpringUtil;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.RuntimeDataReqDto;
import com.digiwin.athena.service.RuntimeDataQuery;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/runtime")
public class RuntimeDataController {

    @PostMapping("/queryData")
    public ResultDto<Object> queryData(@RequestBody RuntimeDataReqDto runtimeDataReqDto){

        RuntimeDataQuery runtimeDataQuery = SpringUtil.getBean(runtimeDataReqDto.getBusinessType(), RuntimeDataQuery.class);

        return ResultDto.createSuccess(runtimeDataQuery.queryRuntimeData(runtimeDataReqDto.getParams()));
    }

    @PostMapping("/saveData")
    public ResultDto<Boolean> saveData(@RequestBody RuntimeDataReqDto runtimeDataReqDto){

        RuntimeDataQuery runtimeDataQuery = SpringUtil.getBean(runtimeDataReqDto.getBusinessType(), RuntimeDataQuery.class);
        runtimeDataQuery.saveRuntimeData(runtimeDataReqDto.getParams());
        return ResultDto.createSuccess(true);
    }

    @PostMapping("/deleteData")
    public ResultDto<Boolean> deleteData(@RequestBody RuntimeDataReqDto runtimeDataReqDto){

        RuntimeDataQuery runtimeDataQuery = SpringUtil.getBean(runtimeDataReqDto.getBusinessType(), RuntimeDataQuery.class);
        runtimeDataQuery.deleteRuntimeData(runtimeDataReqDto.getParams());
        return ResultDto.createSuccess(true);
    }

}
