package com.digiwin.athena.domain.modeldesign;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author wangyan
 * @title:
 * @projectName athena_designer
 * @description: 业务树场景
 * @date
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class BusinessDirTreeInfo {

    private String businessSubCode;
    private String businessSubName;

    // 模型才有数据目标
    private String serviceCode;
    // 模型才有数据目标
    private String modelId;
    // 业务code
    private String businessCode;

    private String type;

    private String path;
    // 描述
    private String description;
    // 数据源，list.get
    private String actionId;

    private Map<String, MultiLanguageDTO> lang;

    // 视图的----视图的顺序
    private int sort;

    private Date createDate;
    // 视图的----默认视图
    private Boolean defaultView;
    // 视图的----自动生成标识
    private Boolean autoGenerateFlag;

    //模型类型 基础base 参数param  交易transaction
    private String modelType;

    // 视图类型 浏览browse 开窗open 仪表盘dashboard
    private String viewType;

    private String eventType;

    //作业类型
    private String category;

    // 触发类型
    private String triggerType;//page界面触发、monitorRule定时触发、event事件触发

    // 视图作业列表
    List<BusinessDirTreeInfo> businessDirTree;

    /**
     * 是否是其他业务对象 默认false
     */
    private Boolean isOther = Boolean.FALSE;
    /**
     * sql生成查询方案新增字段
     * 传值：sql
     */
    private String actionType;
}
