package com.digiwin.athena.dto;

import com.digiwin.athena.http.distribution.FxUser;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import lombok.Data;

@Data
public class FxUserInfoDto {

    private String userName;

    private String userId;
    private String name;

    private String tenantName;

    private Integer tenantId;

    private Integer tenantSid;

    private String fxToken;

    public static FxUserInfoDto create(FxUser fxUser) {
        FxUserInfoDto fxUserInfoDto = new FxUserInfoDto();
        fxUserInfoDto.setUserName(fxUser.getC_user_n1());
        fxUserInfoDto.setName(fxUser.getC_user());
        fxUserInfoDto.setTenantName(fxUser.getC_org_n1());
        fxUserInfoDto.setTenantId(fxUser.getC_ent());
        fxUserInfoDto.setTenantSid(fxUser.getC_ent());
        fxUserInfoDto.setFxToken(CurThreadInfoUtils.getToken());
        fxUserInfoDto.setUserId(fxUser.getC_user());
        return fxUserInfoDto;
    }
}
