package com.digiwin.athena.service.codeStandard.impl;

import com.digiwin.athena.constant.CodeRuleTypeConstant;
import com.digiwin.athena.service.codeStandard.CodeGenerateHandler;
import org.springframework.stereotype.Service;

import java.util.Map;



/**
 * 页面输入生成的code 支持传参数生成code
 * 比如 侦测、服务、流程、参数 这些规则一致的资源
 * 第一段 应用code
 * 第二段 缩写
 * 第三段 自动生成 最终格式 CN_NJHU-89UI_SV_JIHU9867
 * 这些都是通过参数传递生成对应段的code
 */
@Service("inputCodeGenerateHandler")
public class InputCodeGenerateHandler implements CodeGenerateHandler {


    /**
     * 页面输入生成的code 支持传参数生成code
     *
     * @param ruleParams 配置的规则
     * @param paramMap map
     */
    @Override
    public String generateCode(Map<String, String> ruleParams, Map<String, String> paramMap) {
        StringBuilder finalCode = new StringBuilder();
        for (String key : ruleParams.keySet()) {
            //传入的参数匹配规则中的配置，配置上的拼接code
            String value = paramMap.get(key);
            if(CodeRuleTypeConstant.APPLICATION.equals(key)){
                value =   value.replace("-", "");
            }
            if (value != null) {
                finalCode.append(value);
            }
        }

        return finalCode.toString();
    }

}
