package com.digiwin.athena.service.codeStandard.impl;

import com.digiwin.athena.service.codeStandard.CodeGenerateHandler;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 特殊符号  比如 / - _  取规则里面配置的符号
 */
@Service("symbolCodeHandler")
public class SymbolCodeHandler implements CodeGenerateHandler {

    @Override
    public String generateCode(Map<String, String> ruleParams, Map<String, String> param) {
        StringBuilder finalCode = new StringBuilder();
        // 遍历 params 中的键，获取对应的值并拼接
        for (String key : ruleParams.keySet()) {
            String value = ruleParams.get(key);
            if (value != null) {
                finalCode.append(value);
            }
        }

        return finalCode.toString();
    }

}
