package com.digiwin.athena.service.impl;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.dao.PresetDataV2MongoDao;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.sys.PresetDataServiceV2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2023/5/21 <br>
 */
@Service
public class PresetDataServiceV2Impl implements PresetDataServiceV2 {

    @Autowired
    private PresetDataV2MongoDao presetDataV2MongoDao;

    @Override
    public PresetData getPresetDataObject(String key) {
        PresetData presetData = presetDataV2MongoDao.selectOneByKey(key);
        if (Objects.nonNull(presetData)) {
            return presetData;
        }

        throw new BusinessException("there is no PresetData key is : " + key + ", please check!");
    }

    @Override
    public PresetData getPresetDataObjectV2(String key) {
        PresetData presetData = presetDataV2MongoDao.selectOneByKey(key);
        if (Objects.nonNull(presetData)) {
            return presetData;
        }
        return null;
    }

}