package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dao.UserDefinedCenterMongoDao;
import com.digiwin.athena.domain.UserDefinedCenter;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.mysql.domain.user.UserPO;
import com.digiwin.athena.service.RuntimeDataQuery;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service("userDefinedCenterRuntime")
@Slf4j
public class UserDefinedCenterRuntimeDataQuery implements RuntimeDataQuery<UserDefinedCenter> {


    @Autowired
    private UserDefinedCenterMongoDao userDefinedCenterMongoDao;

    @Override
    public UserDefinedCenter queryRuntimeData(JSONObject param) {
        TenantInfo curTokenTenant = CurThreadInfoUtils.getCurTokenTenant();
        UserPO currentUser = UserHelper.getCurrentUser();

        JSONObject conditions = param.getJSONObject("conditions");
        Criteria criteria = null;
        if (conditions !=null){
            criteria = new Criteria();
            for (Map.Entry<String, Object> en : conditions.entrySet()) {
                criteria.and("conditions."+en.getKey()).is(en.getValue());
            }
        }

        UserDefinedCenter userDefinedCenter = userDefinedCenterMongoDao.selectByUserIdAndTenantId(currentUser.getName(), curTokenTenant.getTenantId(), criteria);
        return userDefinedCenter;
    }

    @Override
    public void saveRuntimeData(JSONObject param) {

        TenantInfo curTokenTenant = CurThreadInfoUtils.getCurTokenTenant();
        UserPO currentUser = UserHelper.getCurrentUser();

        UserDefinedCenter userDefinedCenter = queryRuntimeData(param);
        if (userDefinedCenter == null){
            userDefinedCenter = new UserDefinedCenter();

            userDefinedCenter.setUserId(currentUser.getName());
            userDefinedCenter.setTenantId(curTokenTenant.getTenantId());
            userDefinedCenter.setConditions(param.getJSONObject("conditions"));
            userDefinedCenter.setBizCode(param.getString("bizCode"));
            userDefinedCenter.setType(param.getString("type"));

            UserHelper.fillCreateInfo(userDefinedCenter);
        }
        userDefinedCenter.setSettings(param.getJSONObject("settings"));
        UserHelper.fillEditInfo(userDefinedCenter);

        if (StringUtils.isEmpty(userDefinedCenter.getObjId())){
            userDefinedCenterMongoDao.insert(userDefinedCenter);
        }else{
            userDefinedCenterMongoDao.save(userDefinedCenter);
        }
    }

    @Override
    public void deleteRuntimeData(JSONObject param) {
        UserDefinedCenter userDefinedCenter = queryRuntimeData(param);
        if (userDefinedCenter!=null){
            userDefinedCenterMongoDao.delete(userDefinedCenter);
        }
    }
}
