/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.digiwin.athena.mongodb.domain.appCustomConfig.ApplicationCustomConfig;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class RApplicationCustomConfigMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RApplicationCustomConfigMongoDao.class);
    @Autowired
    private MongoRuntimeRepositoryDecorator mongoRuntimeRepositoryDecorator;

    public void insert(ApplicationCustomConfig applicationCustomConfig) {
        this.mongoRuntimeRepositoryDecorator.insert((Object)applicationCustomConfig);
    }

    public void deleteByAdpCodeAndApp(String adpCode, String application) {
        Criteria criteria = Criteria.where((String)"adpCode").in(new Object[]{adpCode}).and("application").is((Object)application);
        this.mongoRuntimeRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), ApplicationCustomConfig.class);
    }

    public void deleteByAdpCodesAndApp(List<String> adpCodes, String adpApplication) {
        Criteria criteria = Criteria.where((String)"adpCode").in(adpCodes).and("application").is((Object)adpApplication);
        this.mongoRuntimeRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), ApplicationCustomConfig.class);
    }

    public List<ApplicationCustomConfig> selectByAdpCodesAndApp(List<String> adpCodes, String application) {
        Criteria criteria = Criteria.where((String)"adpCode").in(adpCodes).and("application").is((Object)application);
        return this.mongoRuntimeRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), ApplicationCustomConfig.class);
    }

    public List<String> selectAdpCodesByApp(String application) {
        Criteria criteria = Criteria.where((String)"application").in(new Object[]{application});
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("adpCode");
        return this.mongoRuntimeRepositoryDecorator.find(query, ApplicationCustomConfig.class).stream().map(ApplicationCustomConfig::getAdpCode).collect(Collectors.toList());
    }

    public void deleteByApplication(String appCode) {
        Criteria criteria = Criteria.where((String)"application").is((Object)appCode);
        this.mongoRuntimeRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), ApplicationCustomConfig.class);
    }
}

