/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.impls;

import com.digiwin.athena.service.RedisService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisServiceImpl
implements RedisService {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public String getString(String key) {
        return this.get(key, String.class);
    }

    @Override
    public void set(String key, Object value, long time) {
        this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
    }

    @Override
    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    @Override
    public Object get(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public <T> T get(String key, Class<T> c) {
        Object obj = this.get(key);
        if (null != obj) {
            return (T)obj;
        }
        return null;
    }

    @Override
    public Boolean del(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    @Override
    public Long del(List<String> keys) {
        return this.redisTemplate.delete(keys);
    }

    @Override
    public Boolean expire(String key, long time) {
        return this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
    }

    @Override
    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    @Override
    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    @Override
    public Long incr(String key) {
        return this.redisTemplate.opsForValue().increment((Object)key);
    }

    @Override
    public Long incr(String key, long delta) {
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    @Override
    public Long decr(String key, long delta) {
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    @Override
    public Object hGet(String key, String hashKey) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
    }

    @Override
    public Boolean hSet(String key, String hashKey, Object value, long time) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
        return this.expire(key, time);
    }

    @Override
    public void hSet(String key, String hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
    }

    @Override
    public Map<Object, Object> hGetAll(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    @Override
    public Boolean hSetAll(String key, Map<String, Object> map, long time) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
        return this.expire(key, time);
    }

    @Override
    public void hSetAll(String key, Map<String, Object> map) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
    }

    @Override
    public void hDel(String key, Object ... hashKey) {
        this.redisTemplate.opsForHash().delete((Object)key, hashKey);
    }

    @Override
    public Boolean hHasKey(String key, String hashKey) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)hashKey);
    }

    @Override
    public Long hIncr(String key, String hashKey, Long delta) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)hashKey, delta.longValue());
    }

    @Override
    public Long hDecr(String key, String hashKey, Long delta) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)hashKey, -delta.longValue());
    }

    @Override
    public Set<Object> sMembers(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    @Override
    public Long sAdd(String key, Object ... values) {
        return this.redisTemplate.opsForSet().add((Object)key, values);
    }

    @Override
    public Long sAdd(String key, long time, Object ... values) {
        Long count = this.redisTemplate.opsForSet().add((Object)key, values);
        this.expire(key, time);
        return count;
    }

    @Override
    public Boolean sIsMember(String key, Object value) {
        return this.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    @Override
    public Long sSize(String key) {
        return this.redisTemplate.opsForSet().size((Object)key);
    }

    @Override
    public Long sRemove(String key, Object ... values) {
        return this.redisTemplate.opsForSet().remove((Object)key, values);
    }

    @Override
    public void lTrim(String key) {
        this.redisTemplate.opsForList().trim((Object)key, 1L, 0L);
    }

    @Override
    public void lTrim(String key, long start, long end) {
        this.redisTemplate.opsForList().trim((Object)key, start, end);
    }

    @Override
    public List<Object> lRange(String key) {
        return this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
    }

    @Override
    public List<Object> lRange(String key, long start, long end) {
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    @Override
    public Long lSize(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    @Override
    public Object lIndex(String key, long index) {
        return this.redisTemplate.opsForList().index((Object)key, index);
    }

    @Override
    public Long lPush(String key, Object value) {
        return this.redisTemplate.opsForList().rightPush((Object)key, value);
    }

    @Override
    public Long lPush(String key, Object value, long time) {
        Long index = this.redisTemplate.opsForList().rightPush((Object)key, value);
        this.expire(key, time);
        return index;
    }

    @Override
    public Long lPushAll(String key, Object ... values) {
        return this.redisTemplate.opsForList().rightPushAll((Object)key, values);
    }

    @Override
    public Long lPushAll(String key, Long time, Object ... values) {
        Long count = this.redisTemplate.opsForList().rightPushAll((Object)key, values);
        this.expire(key, time);
        return count;
    }

    @Override
    public Long lRemove(String key, long count, Object value) {
        return this.redisTemplate.opsForList().remove((Object)key, count, value);
    }
}

