package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.FxUploadFileAResDto;
import com.digiwin.athena.dto.SystemParam;
import com.digiwin.athena.dto.UploadFileV3ResDto;
import com.digiwin.athena.dto.UploadedFileInfoV3ResDto;
import com.digiwin.athena.http.distribution.DeleteFxJobReqDto;
import com.digiwin.athena.http.distribution.FxApiHelper;
import com.digiwin.athena.http.distribution.FxRegisterJobDetailDto;
import com.digiwin.athena.http.distribution.FxUploadedFIleInfoV3ResDto;
import com.digiwin.athena.http.distribution.ProgramAuthResDto;
import com.digiwin.athena.http.distribution.UploadFileV3ReqDto;
import com.digiwin.athena.http.distribution.FxUploadFileV3ResDto;
import com.digiwin.athena.service.FileStoreService;
import com.digiwin.athena.service.MultiPlatformDiffInterface;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@Slf4j
@ConditionalOnProperty(name = "system_env",havingValue = "FenXiao")
public class MultiPlatformDiffImpl implements MultiPlatformDiffInterface {
    @Autowired
    private FxApiHelper fxApiHelper;

    @Autowired
    private FileStoreService fileStoreService;

    @Override
    public JSONObject getSysEnum(){
//        JSONObject sysEnum = fxApiHelper.getSysEnum();
        return null;
    }

    @Override
    public List<SystemParam> getSysEnumV2() {
        JSONArray sysEnumList = fxApiHelper.getSysEnum();
        List<SystemParam> res = new ArrayList<>();

        for (Object o : sysEnumList) {
            JSONObject jo = (JSONObject) o;

            SystemParam systemParam = new SystemParam();
            systemParam.setKey(jo.getString("id"));
            systemParam.setValue(jo.getString("value"));
            systemParam.setDesc(jo.getString("desc"));

            res.add(systemParam);
        }

        return res;
    }

    @Override
    public ProgramAuthResDto getProgramAuth(String code) {
        return fxApiHelper.getProgramAuth(code);
    }

    @Override
    public UploadFileV3ResDto uploadFileV3(MultipartFile file, String componentId, String programId) throws IOException {
        ByteArrayResource byteArrayResource = new ByteArrayResource(file.getBytes()){
            @Override
            public String getFilename() {
                return file.getOriginalFilename();
            }
        };

        UploadFileV3ReqDto uploadFileV3ReqDto = new UploadFileV3ReqDto();
        uploadFileV3ReqDto.setFileItem(byteArrayResource);
        uploadFileV3ReqDto.setFileName(file.getOriginalFilename());
        uploadFileV3ReqDto.setComponentId(componentId);
        uploadFileV3ReqDto.setProgramId(programId);

        FxUploadFileV3ResDto fxUploadFileV3ResDto = fxApiHelper.uploadFileV3(uploadFileV3ReqDto);

        UploadFileV3ResDto res = new UploadFileV3ResDto();
        res.setFileId(fxUploadFileV3ResDto.getId());
        res.setFileName(fxUploadFileV3ResDto.getFileName());
        res.setFileType(fxUploadFileV3ResDto.getFileType());
        res.setUrl(fxUploadFileV3ResDto.getUrl());

        return res;
    }

    @Override
    public FxUploadFileAResDto uploadFile(MultipartFile file, String programCode) throws IOException {

        FxUploadFileAResDto fxUploadFileAResDto = fileStoreService.fxUploadFileA(file, programCode);

        return fxUploadFileAResDto;
    }

    @Override
    public <T> T queryUploadedFileInfo(List<String> fileIds) {
        List<FxUploadedFIleInfoV3ResDto> fxUploadedFIleInfoV3ResDtos = fxApiHelper.queryFileInfoByUUID(fileIds);

        List<UploadedFileInfoV3ResDto> res = fxUploadedFIleInfoV3ResDtos.stream().map(c -> {
            UploadedFileInfoV3ResDto uploadedFileInfoV3ResDto = new UploadedFileInfoV3ResDto();
            uploadedFileInfoV3ResDto.setFileUrl(c.getFileUrl());
            uploadedFileInfoV3ResDto.setFileName(c.getFileName());
            uploadedFileInfoV3ResDto.setFileId(c.getFileId());
            return uploadedFileInfoV3ResDto;
        }).collect(Collectors.toList());
        return (T) res;
    }

    @Override
    public void deleteAllRegisterInfo(Set<String> pageCodes) {
        List<DeleteFxJobReqDto> deleteFxJobReqDtos = new ArrayList<>();
        for (String pageCode : pageCodes) {
            HashMap<String, String> param = new HashMap<>();
            param.put("aah001",pageCode);
            FxRegisterJobDetailDto jobDetailInfo = fxApiHelper.getJobDetailInfo(param);

            if (jobDetailInfo!=null){
                DeleteFxJobReqDto deleteFxJobReqDto = new DeleteFxJobReqDto();
                deleteFxJobReqDto.setAah001(pageCode);
                deleteFxJobReqDto.setAahlock(jobDetailInfo.getAahlock());
                deleteFxJobReqDtos.add(deleteFxJobReqDto);
            }
        }

        if (!deleteFxJobReqDtos.isEmpty()){
            fxApiHelper.deleteJob(deleteFxJobReqDtos);
        }
    }
}
