package com.digiwin.athena.service.appCustomConfig;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.base.BaseConstant;

import com.digiwin.athena.dao.ApplicationCustomConfigV2MongoDao;
import com.digiwin.athena.dao.CustomControlRelationV2MongoDao;
import com.digiwin.athena.mongodb.domain.appCustomConfig.ApplicationCustomConfig;
import com.digiwin.athena.mongodb.domain.appCustomConfig.CustomControlRelation;
import com.digiwin.athena.mongodb.domain.appCustomConfig.CustomControlRes;
import com.digiwin.athena.mongodb.domain.appCustomConfig.SysApplicationCustomConfig;
import com.digiwin.athena.mongodb.domain.appCustomConfig.SysApplicationCustomConfigShare;
import com.digiwin.athena.service.appCustomConfig.event.CustomControlEventManager;
import com.digiwin.athena.service.tenant.TenantService;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class CustomControlEventListener {
    @Resource
    protected TenantService tenantService;
    @Resource
    protected CustomControlEventManager customControlEventManager;

    @Resource
    protected ApplicationCustomConfigV2MongoDao applicationCustomConfigV2MongoDao;

    @Resource
    protected CustomControlRelationV2MongoDao customControlRelationV2MongoDao;

    //protected static final String regexFormat = "\"type\":\"(%s)\"";
    protected static final String regexFormat = "\"isvCustomType\":\"(%s)\"";

    public abstract void doEvent(Object obj);

    @PostConstruct
    public void init(){
     customControlEventManager.registerListener(getType(),this);
    }

    protected abstract CustomControlEventManager.EvenType getType();

    protected Pattern createPattern(Map<String, String> typeMapCode) {
        String types = typeMapCode.keySet().stream().map(s -> Pattern.quote(s)).collect(Collectors.joining(BaseConstant.PIPE));
        String regex = String.format(regexFormat, types);
        Pattern pattern = Pattern.compile(regex);
        return pattern;
    }

    protected Map<String, String> getTypeMapCodeRes(String application, String tenantId) {
        List<ApplicationCustomConfig> applicationCustomConfigsList = applicationCustomConfigV2MongoDao.selectAppControlType(application);
        List<SysApplicationCustomConfig> sysApplicationCustomConfigList = applicationCustomConfigV2MongoDao.selectSysControlType(tenantId);
        // 查询其他租户共享的给我的
        List<SysApplicationCustomConfigShare> sysApplicationCustomConfigShareList = applicationCustomConfigV2MongoDao.findSysShareByShareTenantId(tenantId);
        if(CollectionUtil.isNotEmpty(sysApplicationCustomConfigShareList)){
            List<String> adpCodeLit = sysApplicationCustomConfigShareList.stream().map(SysApplicationCustomConfigShare::getAdpCode).collect(Collectors.toList());
            if(CollectionUtil.isNotEmpty(adpCodeLit)){
                List<SysApplicationCustomConfig> sysByAdpCodeList = applicationCustomConfigV2MongoDao.findSysByAdpCodeList4Share(adpCodeLit);
                for (SysApplicationCustomConfig sysApplicationCustomConfig : sysByAdpCodeList) {
                    if (!sysApplicationCustomConfig.getCustomControl().isEmpty()) {
                        sysApplicationCustomConfigList.add(sysApplicationCustomConfig);
                    }
                }
            }
        }

        Map<String, String> typeMapCode = new HashMap<>();

        for (ApplicationCustomConfig applicationCustomConfig : applicationCustomConfigsList) {
            List<CustomControlRes> customControl = applicationCustomConfig.getCustomControl();
            for (CustomControlRes customControlRes : customControl) {
                typeMapCode.put(customControlRes.getType(), applicationCustomConfig.getAdpCode());
            }
        }

        for (SysApplicationCustomConfig sysApplicationCustomConfig : sysApplicationCustomConfigList) {
            List<CustomControlRes> customControl = sysApplicationCustomConfig.getCustomControl();
            for (CustomControlRes customControlRes : customControl) {
                typeMapCode.put(customControlRes.getType(), sysApplicationCustomConfig.getAdpCode());
            }
        }
        return typeMapCode;
    }

    protected List<CustomControlRelation> matchGenerateRelation(Map<String, Object> pages, Map<String, String> typeMapCode, Pattern pattern, CustomControlRelation param) {
        List<CustomControlRelation> customControlRelations = new ArrayList<>();
        if (CollectionUtils.isEmpty(pages)){
            return customControlRelations;
        }

        for (Map.Entry<String, Object> entry : pages.entrySet()) {

            String key = entry.getKey();
            Object value = entry.getValue();
            String content = JSONObject.toJSONString(value);
            Matcher matcher = pattern.matcher(content);
            Set<String> typeSet = new HashSet<>();
            while (matcher.find()) {
                String matchTypeKey = matcher.group(1);
                typeSet.add(matchTypeKey);
            }

            typeSet.forEach(t->{
                CustomControlRelation customControlRelation = new CustomControlRelation();
                customControlRelation.setAdpApplication(param.getAdpApplication());
                customControlRelation.setAdpTenantId(param.getAdpTenantId());
                customControlRelation.setSourceCode(typeMapCode.get(t));
                customControlRelation.setCustomControlType(t);
                customControlRelation.setTargetCode(param.getTargetCode());
                customControlRelation.setTargetType(getType().getCode());
                //这里兼容老数据，后面dsl存储格式全改了，直接改成 customControlRelation.setUiKey(param.getUiKey());
                customControlRelation.setUiKey(StringUtils.isEmpty(param.getUiKey())?key:param.getUiKey());
                customControlRelation.setName(param.getName());
                customControlRelation.setLang(param.getLang());
                customControlRelation.setExtFieldInfo(param.getExtFieldInfo());
                customControlRelation.setDataViewQueryCode(param.getDataViewQueryCode());
                customControlRelation.setAdpVersion(CurThreadInfoUtils.getAdpVersion());

                UserHelper.fillCreateInfo(customControlRelation);
                UserHelper.fillEditInfo(customControlRelation);

                customControlRelations.add(customControlRelation);
            });
        }
        return customControlRelations;
    }

    protected void handleResult(String targetCode,List<CustomControlRelation> customControlRelations){
        if (StringUtils.isEmpty(CurThreadInfoUtils.getAdpVersion())){
            customControlRelationV2MongoDao.deleteByTargetCode(targetCode);
        }else{
            customControlRelationV2MongoDao.deleteByTargetCodeAndAdpVersion(targetCode,CurThreadInfoUtils.getAdpVersion());
        }
        if (!customControlRelations.isEmpty()) {
            customControlRelationV2MongoDao.insertAll(customControlRelations);
        }
    }
}
