/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.digiwin.athena.mongodb.domain.appCustomConfig.ApplicationCustomConfig;
import com.digiwin.athena.mongodb.domain.appCustomConfig.CustomControlRes;
import com.digiwin.athena.mongodb.domain.appCustomConfig.SysApplicationCustomConfig;
import com.digiwin.athena.mongodb.domain.appCustomConfig.SysApplicationCustomConfigShare;
import com.digiwin.athena.mongodb.repository.MongoMultiRepositoryDecorator;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import com.digiwin.athena.utils.SwitchDatabaseUtils;
import com.digiwin.athena.utils.UpdateUtils;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class ApplicationCustomConfigV2MongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationCustomConfigV2MongoDao.class);
    @Resource
    private MongoMultiRepositoryDecorator mongoMultiRepositoryDecorator;
    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public void insert(ApplicationCustomConfig applicationCustomConfig) {
        this.mongoMultiRepositoryDecorator.insert((Object)applicationCustomConfig);
    }

    public void updateById(ApplicationCustomConfig applicationCustomConfig) {
        Criteria criteria = Criteria.where((String)"id").is((Object)applicationCustomConfig.getId()).and("application").is((Object)applicationCustomConfig.getApplication());
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoMultiRepositoryDecorator.updateFirst(query, UpdateUtils.getUpdate((Object)applicationCustomConfig), ApplicationCustomConfig.class);
    }

    public List<ApplicationCustomConfig> find(Query query) {
        return this.mongoMultiRepositoryDecorator.find(query, ApplicationCustomConfig.class);
    }

    public ApplicationCustomConfig findOne(String adpCode) {
        List<ApplicationCustomConfig> applicationCustomConfigList = this.find(new Query((CriteriaDefinition)Criteria.where((String)"adpCode").is((Object)adpCode)));
        return applicationCustomConfigList.isEmpty() ? null : applicationCustomConfigList.get(0);
    }

    public void deleteByAdpCode(String adpCode) {
        this.mongoMultiRepositoryDecorator.remove(new Query((CriteriaDefinition)Criteria.where((String)"adpCode").is((Object)adpCode)), ApplicationCustomConfig.class);
    }

    public boolean checkIsExistPluginName(String name) {
        Criteria criteria = Criteria.where((String)"name").is((Object)name);
        return this.judgeSelectResult(criteria);
    }

    public boolean checkIsExistPluginNameExcludeCurId(String name, String adpCode) {
        Criteria criteria = Criteria.where((String)"name").is((Object)name).and("adpCode").ne((Object)adpCode);
        return this.judgeSelectResult(criteria);
    }

    public ApplicationCustomConfig findByAdpCode(String adpCode) {
        Criteria criteria = Criteria.where((String)"adpCode").is((Object)adpCode);
        return (ApplicationCustomConfig)this.mongoMultiRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), ApplicationCustomConfig.class);
    }

    public List<SysApplicationCustomConfig> findSysByAdpTenantId(String tenantId) {
        Criteria criteria = Criteria.where((String)"adpTenantId").is((Object)tenantId);
        Query query = this.simpleInfoListQueryCondition(criteria);
        return this.mongoSystemRepositoryDecorator.find(query, SysApplicationCustomConfig.class);
    }

    public List<SysApplicationCustomConfigShare> findSysShareByShareTenantId(String tenantId) {
        Criteria criteria = Criteria.where((String)"shareTenantId").is((Object)tenantId);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoSystemRepositoryDecorator.find(query, SysApplicationCustomConfigShare.class);
    }

    public List<SysApplicationCustomConfigShare> findSysShareByAdpCode(String adpCode) {
        Criteria criteria = Criteria.where((String)"adpCode").is((Object)adpCode);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoSystemRepositoryDecorator.find(query, SysApplicationCustomConfigShare.class);
    }

    public SysApplicationCustomConfig findSysByAdpCode(String adpCode) {
        Criteria criteria = Criteria.where((String)"adpCode").is((Object)adpCode);
        return (SysApplicationCustomConfig)this.mongoSystemRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), SysApplicationCustomConfig.class);
    }

    public void insertSys(SysApplicationCustomConfig sysApplicationCustomConfig) {
        this.mongoSystemRepositoryDecorator.insert((Object)sysApplicationCustomConfig);
    }

    public void insertSysShare(SysApplicationCustomConfigShare sysApplicationCustomConfigShare) {
        this.mongoSystemRepositoryDecorator.insert((Object)sysApplicationCustomConfigShare);
    }

    public List<ApplicationCustomConfig> selectListByApplication(String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application);
        Query query = this.simpleInfoListQueryCondition(criteria);
        return this.mongoMultiRepositoryDecorator.find(query, ApplicationCustomConfig.class);
    }

    private Query simpleInfoListQueryCondition(Criteria criteria) {
        Query query = new Query((CriteriaDefinition)criteria).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"}));
        Field fields = query.fields();
        fields.include("adpCode");
        fields.include("name");
        fields.include("description");
        fields.include("lang");
        fields.include("adpTenantId");
        fields.include("path");
        fields.include("chunkName");
        fields.include("isMF");
        fields.include("customControl.type");
        fields.include("customControl.title");
        fields.include("customControl.lang");
        return query;
    }

    public void save(ApplicationCustomConfig applicationCustomConfig) {
        this.mongoMultiRepositoryDecorator.save((Object)applicationCustomConfig);
    }

    public boolean checkIsExistControlType(List<String> typeList) {
        Criteria criteria = Criteria.where((String)"customControl.type").in(typeList);
        return this.judgeSelectResult(criteria);
    }

    public List<String> selectExistControlType(List<String> typeList) {
        Criteria criteria = Criteria.where((String)"customControl.type").in(typeList);
        return this.getRepeatControlType(criteria, typeList);
    }

    public boolean checkIsExistControlTypeExcludeCur(List<String> typeList, String adpCode) {
        Criteria criteria = Criteria.where((String)"customControl.type").in(typeList).and("adpCode").ne((Object)adpCode);
        return this.judgeSelectResult(criteria);
    }

    private boolean judgeSelectResult(Criteria criteria) {
        Query query = new Query((CriteriaDefinition)criteria).limit(1);
        long count2 = this.mongoSystemRepositoryDecorator.count(query, SysApplicationCustomConfig.class);
        if (count2 > 0L) {
            return true;
        }
        Long count1 = (Long)SwitchDatabaseUtils.switchStandardDatabase(() -> this.mongoMultiRepositoryDecorator.count(query, ApplicationCustomConfig.class));
        if (count1 > 0L) {
            return true;
        }
        count1 = (Long)SwitchDatabaseUtils.switchIndividualDatabase(() -> this.mongoMultiRepositoryDecorator.count(query, ApplicationCustomConfig.class));
        return count1 > 0L;
    }

    public List<String> selectExistControlTypeExcludeCur(List<String> typeList, String adpCode) {
        Criteria criteria = Criteria.where((String)"customControl.type").in(typeList).and("adpCode").ne((Object)adpCode);
        return this.getRepeatControlType(criteria, typeList);
    }

    public List<SysApplicationCustomConfigShare> selectExistShareTenantId(String adpCode) {
        Criteria criteria = Criteria.where((String)"adpCode").is((Object)adpCode).and("status").is((Object)"Y");
        Query query = new Query((CriteriaDefinition)criteria);
        List sysApplicationCustomConfigs = this.mongoSystemRepositoryDecorator.find(query, SysApplicationCustomConfigShare.class);
        return sysApplicationCustomConfigs;
    }

    private List<String> getRepeatControlType(Criteria criteria, List<String> typeList) {
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("customControl.type");
        HashSet<String> typeSet = new HashSet<String>(typeList);
        List sysApplicationCustomConfigs = this.mongoSystemRepositoryDecorator.find(query, SysApplicationCustomConfig.class);
        List applicationCustomConfigs = (List)SwitchDatabaseUtils.switchStandardDatabase(() -> this.mongoMultiRepositoryDecorator.find(query, ApplicationCustomConfig.class));
        List individualApplicationCustomConfigs = (List)SwitchDatabaseUtils.switchIndividualDatabase(() -> this.mongoMultiRepositoryDecorator.find(query, ApplicationCustomConfig.class));
        List controlList = applicationCustomConfigs.stream().map(ApplicationCustomConfig::getCustomControl).collect(Collectors.toList());
        controlList.addAll(individualApplicationCustomConfigs.stream().map(ApplicationCustomConfig::getCustomControl).collect(Collectors.toList()));
        controlList.addAll(sysApplicationCustomConfigs.stream().map(SysApplicationCustomConfig::getCustomControl).collect(Collectors.toList()));
        return controlList.stream().flatMap(Collection::stream).map(CustomControlRes::getType).filter(t -> typeSet.contains(t)).distinct().collect(Collectors.toList());
    }

    public void saveSys(SysApplicationCustomConfig sysApplicationCustomConfig) {
        this.mongoSystemRepositoryDecorator.save((Object)sysApplicationCustomConfig);
    }

    public void deleteSysByAdpCode(String adpCode) {
        this.mongoSystemRepositoryDecorator.remove(new Query((CriteriaDefinition)Criteria.where((String)"adpCode").is((Object)adpCode)), SysApplicationCustomConfig.class);
    }

    public List<ApplicationCustomConfig> selectCustomControlByApplication(String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("customControl");
        fields.include("name");
        fields.include("lang");
        return this.mongoMultiRepositoryDecorator.find(query, ApplicationCustomConfig.class);
    }

    public List<SysApplicationCustomConfig> selectSysCustomControlByTenantId(String tenantId) {
        Criteria criteria = Criteria.where((String)"adpTenantId").is((Object)tenantId);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("customControl");
        fields.include("name");
        fields.include("lang");
        return this.mongoSystemRepositoryDecorator.find(query, SysApplicationCustomConfig.class);
    }

    public List<ApplicationCustomConfig> selectAppControlType(String application) {
        Criteria criteria1 = Criteria.where((String)"application").is((Object)application);
        Query query1 = new Query((CriteriaDefinition)criteria1);
        Field fields1 = query1.fields();
        fields1.include("adpCode");
        fields1.include("customControl.type");
        return this.mongoMultiRepositoryDecorator.find(query1, ApplicationCustomConfig.class);
    }

    public List<SysApplicationCustomConfig> selectSysControlType(String tenantId) {
        Criteria criteria2 = Criteria.where((String)"adpTenantId").is((Object)tenantId);
        Query query2 = new Query((CriteriaDefinition)criteria2);
        Field fields2 = query2.fields();
        fields2.include("adpCode");
        fields2.include("customControl.type");
        return this.mongoSystemRepositoryDecorator.find(query2, SysApplicationCustomConfig.class);
    }

    public List<SysApplicationCustomConfig> selectSysExcludeCustomControl(List<String> adpCodes) {
        Criteria criteria = Criteria.where((String)"adpCode").in(adpCodes);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.exclude("customControl");
        return this.mongoSystemRepositoryDecorator.find(query, SysApplicationCustomConfig.class);
    }

    public List<SysApplicationCustomConfig> findSysByAdpCodeList(List<String> codeList) {
        Criteria criteria = Criteria.where((String)"adpCode").in(codeList);
        Query query = this.simpleInfoListQueryCondition(criteria);
        return this.mongoSystemRepositoryDecorator.find(query, SysApplicationCustomConfig.class);
    }

    public List<SysApplicationCustomConfig> findSysByAdpCodeList4Share(List<String> codeList) {
        Criteria criteria = Criteria.where((String)"adpCode").in(codeList);
        Query query = new Query((CriteriaDefinition)criteria).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"}));
        return this.mongoSystemRepositoryDecorator.find(query, SysApplicationCustomConfig.class);
    }

    public List<ApplicationCustomConfig> selectExcludeCustomControl(String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.exclude("customControl");
        return this.mongoMultiRepositoryDecorator.find(query, ApplicationCustomConfig.class);
    }
}

