package com.digiwin.athena.actuator;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.http.asset.ThirdPartyApiHelper;
import com.digiwin.athena.utils.JSUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@Slf4j
public class HttpActuator {
    @Autowired
    private ThirdPartyApiHelper thirdPartyApiHelper;

    public Object execute(HttpExecuteConfig config, Object requestParams,Map<String,Object> placeholderParams,Class returnType) {
        ObjectMapper mapper = new ObjectMapper();

        if (!StringUtils.isEmpty(config.getRequestScript())) {
            try {
                requestParams = JSUtil.evalRequest(config.getRequestScript(), mapper.writeValueAsString(requestParams), Map.class);
            } catch (JsonProcessingException e) {
                log.error("数据json格式化异常",e);
                throw new RuntimeException("数据json格式化异常");
            }
        }
        String url = config.getUrl();

        ReqPlaceholder[] values = ReqPlaceholder.values();
        for (ReqPlaceholder value : values) {
            if (url.contains(value.getPlaceholder())){
                url = url.replace(value.getPlaceholder(), placeholderParams.get(value.getPlaceholder()).toString());
            }
        }

        Map<String,Object> headers = config.getHeaders();
        if (headers != null) {
            for (Map.Entry<String,Object> entry : headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue().toString();

                for (ReqPlaceholder reqPlaceholder : values) {
                    if (value.contains(reqPlaceholder.getPlaceholder())) {
                        String v = value.replace(reqPlaceholder.getPlaceholder(), placeholderParams.get(reqPlaceholder.getPlaceholder()).toString());
                        headers.put(key, v);
                    }
                }
            }
        }

        JSONObject response = thirdPartyApiHelper.callHttp(url,config.getMethod(),headers,requestParams);


        if (!StringUtils.isEmpty(config.getResponseScript())) {
            return JSUtil.evalResponse(config.getResponseScript(), JSONObject.toJSONString(response), returnType);
        }
        return response.toJavaObject(returnType);
    }
}
