package com.digiwin.athena.dao;

import com.digiwin.athena.domain.OperationRecordPO;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

@Slf4j
@Repository
public class OperationRecordMongoDao {

    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public void insert(Collection<OperationRecordPO> entityList) {
        mongoSystemRepositoryDecorator.insertAll(entityList);
    }

    public List<OperationRecordPO> getListByCode(String application, String code, String tableName, String branch) {
        Criteria criteria = Criteria.where("application").is(application).and("contentKey").is(code).and("tableName").is(tableName).and("branch").is(branch);
        Query query = new Query(criteria);
        query.fields().exclude("content");
        query.with(Sort.by(Sort.Direction.DESC,"_id"));
        return mongoSystemRepositoryDecorator.find(query,OperationRecordPO.class);
    }

    public List<OperationRecordPO> getListByCodes(String application, List<String> codes, String tableName, String branch) {
        Criteria criteria = Criteria.where("application").is(application).and("contentKey").in(codes).and("tableName").is(tableName).and("branch").is(branch);
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.find(query,OperationRecordPO.class);
    }

    public OperationRecordPO getById(String id) {
        Criteria criteria = Criteria.where("_id").is(id);
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.findOne(query,OperationRecordPO.class);
    }

    public List<OperationRecordPO> getListByCodeAndAdpVersionNew(String appCode, String code, String tableName, String branch,String adpVersion) {
        Criteria criteria = Criteria.where("appCode").is(appCode).and("contentKey").is(code).and("tableName").is(tableName).and("adpVersion").is(adpVersion);
        Query query = new Query(criteria);
        query.fields().exclude("content");
        query.with(Sort.by(Sort.Direction.DESC,"_id"));
        return mongoSystemRepositoryDecorator.find(query,OperationRecordPO.class);
    }

}
