package com.digiwin.athena.dao;

import com.digiwin.athena.domain.AppBranchBakPO;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class AppBranchBakMongoDao {

    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public void insert(List<AppBranchBakPO> entityList) {
        mongoSystemRepositoryDecorator.insertAll(entityList);
    }

    public void update(AppBranchBakPO entity) {
        mongoSystemRepositoryDecorator.save(entity);
    }

    public AppBranchBakPO selectOneByCondition(Criteria criteria) {
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.findOne(query, AppBranchBakPO.class);
    }

    public List<AppBranchBakPO> selectListByCondition(Criteria criteria) {
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.find(query, AppBranchBakPO.class);
    }

    public void deleteListByCondition(Criteria criteria) {
        Query query = new Query(criteria);
        mongoSystemRepositoryDecorator.delete(query, AppBranchBakPO.class);
    }

}
