package com.digiwin.athena.mongodb.domain.appCustomConfig;

import com.digiwin.athena.constant.Constant;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 应用定制插件
 */
@Document(collection = "applicationCustomizedConfig")
public class ApplicationCustomConfig {

    @Id
    private String id;
    /**
     * 应用代号
     */
    private String application;
    /**
     * 同application
     */
    private String appId;
    /**
     * 插件名称
     */
    private String name;
    /**
     * 插件描述
     */
    private String description;
    /**
     * 定制包路径
     */
    private String path;
    /**
     * 定制包打包后的chunk名称
     */
    private String chunkName;
    /**
     * 是否为微前端
     */
    private boolean isMF;
    /**
     * 租户id
     */
    private String tenantId= Constant.SYSTEM;

    /**
     * 微前端中被导出的模块名称
     */
    private String remoteName;
    /**
     *微前端中被导出的模块路径
     */
    private String exposedModule;

    private Map<String, Map<String, String>> lang;

    private String createBy;
    private Date createDate;
    private String editBy;
    private Date editDate;

    private List<CustomControlRes> customControl=new ArrayList<>();

    private String adpCode;

    /**
     * 编译发版时需要的字段
     */
    @Transient
    private String type;


    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAdpCode() {
        return adpCode;
    }

    public void setAdpCode(String adpCode) {
        this.adpCode = adpCode;
    }

    public List<CustomControlRes> getCustomControl() {
        return customControl;
    }

    public void setCustomControl(List<CustomControlRes> customControl) {
        this.customControl = customControl;
    }

    public Map<String, Map<String, String>> getLang() {
        return lang;
    }

    public void setLang(Map<String, Map<String, String>> lang) {
        this.lang = lang;
    }

    public String getRemoteName() {
        return remoteName;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public String getExposedModule() {
        return exposedModule;
    }

    public void setExposedModule(String exposedModule) {
        this.exposedModule = exposedModule;
    }

    public boolean getIsMF() {
        return isMF;
    }

    public void setIsMF(boolean MF) {
        isMF = MF;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getApplication() {
        return application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getChunkName() {
        return chunkName;
    }

    public void setChunkName(String chunkName) {
        this.chunkName = chunkName;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getEditBy() {
        return editBy;
    }

    public void setEditBy(String editBy) {
        this.editBy = editBy;
    }

    public Date getEditDate() {
        return editDate;
    }

    public void setEditDate(Date editDate) {
        this.editDate = editDate;
    }

}
