/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.actuator;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.actuator.HttpExecuteConfig;
import com.digiwin.athena.actuator.ReqPlaceholder;
import com.digiwin.athena.http.asset.ThirdPartyApiHelper;
import com.digiwin.athena.utils.JSUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpActuator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpActuator.class);
    @Autowired
    private ThirdPartyApiHelper thirdPartyApiHelper;

    public Object execute(HttpExecuteConfig config, Object requestParams, Map<String, Object> placeholderParams, Class returnType) {
        ReqPlaceholder[] values;
        ObjectMapper mapper = new ObjectMapper();
        if (!StringUtils.isEmpty((CharSequence)config.getRequestScript())) {
            try {
                requestParams = JSUtil.evalRequest((String)config.getRequestScript(), (String)mapper.writeValueAsString(requestParams), Map.class);
            }
            catch (JsonProcessingException e) {
                log.error("\u6570\u636ejson\u683c\u5f0f\u5316\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u6570\u636ejson\u683c\u5f0f\u5316\u5f02\u5e38");
            }
        }
        String url = config.getUrl();
        for (ReqPlaceholder value : values = ReqPlaceholder.values()) {
            if (!url.contains(value.getPlaceholder())) continue;
            url = url.replace(value.getPlaceholder(), placeholderParams.get(value.getPlaceholder()).toString());
        }
        Map<String, Object> headers = config.getHeaders();
        if (headers != null) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue().toString();
                for (ReqPlaceholder reqPlaceholder : values) {
                    if (!value.contains(reqPlaceholder.getPlaceholder())) continue;
                    String v = value.replace(reqPlaceholder.getPlaceholder(), placeholderParams.get(reqPlaceholder.getPlaceholder()).toString());
                    headers.put(key, v);
                }
            }
        }
        JSONObject response = this.thirdPartyApiHelper.callHttp(url, config.getMethod(), headers, requestParams);
        if (!StringUtils.isEmpty((CharSequence)config.getResponseScript())) {
            return JSUtil.evalResponse((String)config.getResponseScript(), (String)JSONObject.toJSONString((Object)response), (Class)returnType);
        }
        return response.toJavaObject(returnType);
    }
}

